/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.core.ui.preferences;

import at.medevit.elexis.inbox.core.ui.LabResultLabelProvider;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.Images;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class InboxPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String INBOX = "inbox/";
    public static final String INBOX_LABRESULT_LBL_CHOOSEN = "inbox/labresult/label/choosen";
    public static final String INBOX_LABRESULT_LBL_AVAILABLE = "inbox/labresult/label/available";
    public static final String DEF_CHOOSEN = LabResultLabelProvider.LabelFields.LAB_VALUE_SHORT.toString() + "," + LabResultLabelProvider.LabelFields.LAB_VALUE_NAME.toString() + "," + LabResultLabelProvider.LabelFields.LAB_RESULT.toString();
    public static final String DEF_AVAILABLE = LabResultLabelProvider.LabelFields.REF_RANGE.toString() + "," + LabResultLabelProvider.LabelFields.ORIGIN.toString() + "," + LabResultLabelProvider.LabelFields.DATE.toString();
    private static List<LabResultLabelProvider.LabelFields> choosenLabels;
    private static ListViewer lvChoosen;
    private ListViewer lvAvailable;
    private static String[] choosen;
    private String[] available;
    private Label lblPreview;
    private String prefixPrevLabel = "Label Vorschau";

    public InboxPreferences() {
        super("Inbox");
        choosen = ConfigServiceHolder.getUser((String)INBOX_LABRESULT_LBL_CHOOSEN, (String)DEF_CHOOSEN).split(",");
        int nrValues = LabResultLabelProvider.LabelFields.values().length;
        this.available = choosen.length == nrValues ? new String[0] : ConfigServiceHolder.getUser((String)INBOX_LABRESULT_LBL_AVAILABLE, (String)DEF_AVAILABLE).split(",");
    }

    protected Control createContents(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(1808));
        area.setLayout((Layout)new GridLayout(1, true));
        Group grpLabel = new Group(area, 0);
        grpLabel.setLayoutData((Object)new GridData(1808));
        grpLabel.setLayout((Layout)new GridLayout(3, true));
        grpLabel.setText("Laborwerte Label Optionen");
        Label lblChoosen = new Label((Composite)grpLabel, 0);
        lblChoosen.setText("Gew\u00e4hlt");
        new Label((Composite)grpLabel, 0);
        Label lblAvailable = new Label((Composite)grpLabel, 0);
        lblAvailable.setText("Noch verf\u00fcgbar");
        GridData gdLvChoosen = new GridData();
        gdLvChoosen.horizontalAlignment = 4;
        gdLvChoosen.verticalAlignment = 0x1000000;
        gdLvChoosen.minimumHeight = 100;
        gdLvChoosen.heightHint = 100;
        lvChoosen = new ListViewer((Composite)grpLabel, 2560);
        lvChoosen.getList().setLayoutData((Object)gdLvChoosen);
        lvChoosen.setContentProvider((IContentProvider)new ArrayContentProvider());
        lvChoosen.setInput((Object)choosen);
        Composite btnArea = new Composite((Composite)grpLabel, 0);
        btnArea.setLayout((Layout)new GridLayout());
        btnArea.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        Button btnAdd = new Button(btnArea, 8);
        btnAdd.setImage(Images.IMG_PREVIOUS.getImage());
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)InboxPreferences.this.lvAvailable.getSelection();
                String item = (String)sel.getFirstElement();
                if (item != null) {
                    InboxPreferences.this.lvAvailable.remove((Object)item);
                    lvChoosen.add((Object)item);
                    InboxPreferences.this.lblPreview.setText(InboxPreferences.this.getPreviewLabel());
                }
            }
        });
        Button btnRemove = new Button(btnArea, 8);
        btnRemove.setImage(Images.IMG_NEXT.getImage());
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)lvChoosen.getSelection();
                String item = (String)sel.getFirstElement();
                if (item != null) {
                    lvChoosen.remove((Object)item);
                    InboxPreferences.this.lvAvailable.add((Object)item);
                    InboxPreferences.this.lblPreview.setText(InboxPreferences.this.getPreviewLabel());
                }
            }
        });
        GridData gdLvAvailable = new GridData();
        gdLvAvailable.horizontalAlignment = 4;
        gdLvAvailable.verticalAlignment = 0x1000000;
        gdLvAvailable.minimumHeight = 100;
        gdLvAvailable.heightHint = 100;
        this.lvAvailable = new ListViewer((Composite)grpLabel, 2560);
        this.lvAvailable.getList().setLayoutData((Object)gdLvAvailable);
        this.lvAvailable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lvAvailable.setInput((Object)this.available);
        new Label((Composite)grpLabel, 0);
        new Label((Composite)grpLabel, 0);
        new Label((Composite)grpLabel, 0);
        this.lblPreview = new Label((Composite)grpLabel, 0);
        this.lblPreview.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.lblPreview.setText(this.getPreviewLabel());
        return area;
    }

    public boolean performOk() {
        ConfigServiceHolder.setUser((String)INBOX_LABRESULT_LBL_CHOOSEN, (String)this.getListAsString(lvChoosen.getList().getItems()));
        ConfigServiceHolder.setUser((String)INBOX_LABRESULT_LBL_AVAILABLE, (String)this.getListAsString(this.lvAvailable.getList().getItems()));
        InboxPreferences.loadChoosenLabel();
        return super.performOk();
    }

    private String getPreviewLabel() {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lvChoosen.getList().getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s);
            sb.append(" ");
            ++n2;
        }
        return this.prefixPrevLabel + ":\t" + sb.toString();
    }

    private String getListAsString(String[] items) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            sb.append(item);
            sb.append(",");
            ++n2;
        }
        return sb.toString();
    }

    public void init(IWorkbench workbench) {
    }

    private static void loadChoosenLabel() {
        String[] labels = ConfigServiceHolder.getUser((String)INBOX_LABRESULT_LBL_CHOOSEN, (String)DEF_CHOOSEN).split(",");
        choosenLabels = new ArrayList<LabResultLabelProvider.LabelFields>();
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            LabResultLabelProvider.LabelFields lblField = LabResultLabelProvider.LabelFields.getEnum(label);
            if (lblField != null) {
                choosenLabels.add(lblField);
            }
            ++n2;
        }
    }

    public static List<LabResultLabelProvider.LabelFields> getChoosenLabel() {
        if (choosenLabels == null || choosenLabels.isEmpty()) {
            InboxPreferences.loadChoosenLabel();
        }
        return choosenLabels;
    }
}

