/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.core.ui;

import at.medevit.elexis.inbox.ui.part.model.GroupedInboxElements;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

public class LabGroupedInboxElements
extends GroupedInboxElements {
    private static DateTimeFormatter defaultDateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public String getUri() {
        if (this.getPatient() != null) {
            return "lab://" + StoreToStringServiceHolder.getStoreToString((Object)this.getPatient());
        }
        return null;
    }

    public String getLabel() {
        if (!this.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getElements().size() + " Laborresultate");
            int pathologicCount = this.getPathologicCount();
            if (pathologicCount > 0) {
                sb.append(" davon " + pathologicCount + " pathologisch");
            }
            return sb.toString();
        }
        return "Keine Laborresultate";
    }

    public boolean isMatching(ILabResult labResult) {
        if (!this.isEmpty()) {
            if (((ILabResult)this.getFirstElement().getObject()).getObservationTime() != null && labResult.getObservationTime() != null) {
                return ((ILabResult)this.getFirstElement().getObject()).getObservationTime().toLocalDate().equals(labResult.getObservationTime().toLocalDate());
            }
            if (((ILabResult)this.getFirstElement().getObject()).getDate() != null && labResult.getDate() != null) {
                return ((ILabResult)this.getFirstElement().getObject()).getDate().equals(labResult.getDate());
            }
        }
        return this.isEmpty();
    }

    private int getPathologicCount() {
        return (int)this.getElements().stream().map(ie -> (ILabResult)ie.getObject()).filter(lr -> lr.isPathologic()).count();
    }

    public boolean isPathologic() {
        return this.getElements().stream().map(ie -> (ILabResult)ie.getObject()).anyMatch(lr -> lr.isPathologic());
    }

    public List<ILabResult> getPathologicResults() {
        return this.getElements().stream().map(ie -> (ILabResult)ie.getObject()).filter(lr -> lr.isPathologic()).collect(Collectors.toList());
    }
}

