/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.inbox.core.ui;

import at.medevit.elexis.inbox.core.ui.LabGroupedInboxElements;
import at.medevit.elexis.inbox.core.ui.LabResultLabelProvider;
import at.medevit.elexis.inbox.core.ui.filter.LabInboxFilter;
import at.medevit.elexis.inbox.core.ui.filter.PathologicInboxFilter;
import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.ui.part.model.GroupedInboxElements;
import at.medevit.elexis.inbox.ui.part.model.PatientInboxElements;
import at.medevit.elexis.inbox.ui.part.provider.IInboxElementUiProvider;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LabServiceHolder;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.LabResult;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.IViewDescriptor;
import org.slf4j.LoggerFactory;

public class LabResultUiProvider
implements IInboxElementUiProvider {
    private static DecorationOverlayIcon pathologicLabImage;
    private IViewDescriptor rocheView;
    private IViewDescriptor labView;
    private LabResultLabelProvider labelProvider = new LabResultLabelProvider();
    private LabInboxFilter filter;
    private PathologicInboxFilter pathologicfilter;
    private List<ViewerFilter> filters;

    public ImageDescriptor getFilterImage(ViewerFilter filter) {
        if (filter == this.filter) {
            return Images.IMG_VIEW_LABORATORY.getImageDescriptor();
        }
        if (filter == this.pathologicfilter) {
            if (pathologicLabImage == null) {
                LabResultUiProvider.initializeImages();
            }
            return pathologicLabImage;
        }
        return null;
    }

    public List<ViewerFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<ViewerFilter>();
            this.filter = new LabInboxFilter();
            this.filters.add(this.filter);
            this.pathologicfilter = new PathologicInboxFilter();
            this.filters.add(this.pathologicfilter);
        }
        return this.filters;
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IColorProvider getColorProvider() {
        return this.labelProvider;
    }

    public IToolTipProvider getToolTipProvider() {
        return this.labelProvider;
    }

    public boolean isProviderFor(IInboxElement element) {
        if (element instanceof LabGroupedInboxElements) {
            return true;
        }
        Object obj = element.getObject();
        if (obj instanceof LabResult) {
            return true;
        }
        return obj instanceof ILabResult;
    }

    public LocalDate getObjectDate(IInboxElement element) {
        if (element instanceof GroupedInboxElements) {
            IInboxElement firstElement = ((GroupedInboxElements)element).getFirstElement();
            if (firstElement.getObject() instanceof ILabResult) {
                if (((ILabResult)firstElement.getObject()).getObservationTime() != null) {
                    return ((ILabResult)firstElement.getObject()).getObservationTime().toLocalDate();
                }
                if (((ILabResult)firstElement.getObject()).getDate() != null) {
                    return ((ILabResult)firstElement.getObject()).getDate();
                }
            }
        } else if (element.getObject() instanceof ILabResult) {
            return ((ILabResult)element.getObject()).getObservationTime().toLocalDate();
        }
        return null;
    }

    private static void initializeImages() {
        ImageDescriptor[] overlays = new ImageDescriptor[]{AbstractUIPlugin.imageDescriptorFromPlugin((String)"at.medevit.elexis.inbox.ui", (String)"/rsc/img/achtung_overlay.png")};
        pathologicLabImage = new DecorationOverlayIcon(Images.IMG_VIEW_LABORATORY.getImage(), overlays);
    }

    public void doubleClicked(IInboxElement element) {
        if (element instanceof LabGroupedInboxElements) {
            if (this.rocheView == null && this.labView == null) {
                this.rocheView = PlatformUI.getWorkbench().getViewRegistry().find("at.medevit.elexis.roche.labor.view");
                this.labView = PlatformUI.getWorkbench().getViewRegistry().find("ch.elexis.Labor");
            }
            Display.getDefault().asyncExec(() -> {
                try {
                    if (this.rocheView != null) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this.rocheView.getId());
                    } else if (this.labView != null) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this.labView.getId());
                    }
                }
                catch (PartInitException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Error showing lab view", (Throwable)e);
                }
            });
        }
    }

    public boolean isVisible(IInboxElement element) {
        ILabResult labResult;
        if (element instanceof LabGroupedInboxElements) {
            return true;
        }
        Object obj = element.getObject();
        if (obj instanceof LabResult) {
            return StringUtils.isNotBlank((CharSequence)((LabResult)obj).getResult());
        }
        if (obj instanceof ILabResult && StringUtils.isBlank((CharSequence)(labResult = (ILabResult)obj).getResult())) {
            Result result;
            if (LabItemTyp.FORMULA == labResult.getItem().getTyp() && (result = LabServiceHolder.get().evaluate(labResult)).isOK() && StringUtils.isNotBlank((CharSequence)((CharSequence)result.get()))) {
                labResult.setResult((String)result.get());
                CoreModelServiceHolder.get().save((Identifiable)labResult);
            }
            return StringUtils.isNotBlank((CharSequence)labResult.getResult());
        }
        return true;
    }

    public boolean isGrouped() {
        return true;
    }

    public GroupedInboxElements getGrouped(PatientInboxElements patientInboxElements, IInboxElement element) {
        LabGroupedInboxElements ret = null;
        ILabResult labResult = (ILabResult)element.getObject();
        Optional<LabGroupedInboxElements> existing = patientInboxElements.getElements().stream().filter(iie -> iie instanceof LabGroupedInboxElements).map(iie -> (LabGroupedInboxElements)((Object)iie)).filter(lge -> lge.isMatching(labResult)).findFirst();
        ret = existing.isPresent() ? existing.get() : new LabGroupedInboxElements();
        ret.addElement(element);
        return ret;
    }
}

