/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.model.po;

import at.medevit.elexis.impfplan.model.ArticleToImmunisationModel;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.model.Identifiable;
import ch.elexis.data.Artikel;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Vaccination
extends PersistentObject {
    public static final String TABLENAME = "AT_MEDEVIT_ELEXIS_IMPFPLAN";
    static final String VERSION = "1.0.0";
    public static final String FLD_PATIENT_ID = "Patient_ID";
    public static final String FLD_ARTIKEL_REF = "Artikel_REF";
    public static final String FLD_BUSS_NAME = "BusinessName";
    public static final String FLD_EAN = "ean";
    public static final String FLD_ATCCODE = "ATCCode";
    public static final String FLD_LOT_NO = "lotnr";
    public static final String FLD_DOA = "dateOfAdministration";
    public static final String FLD_ADMINISTRATOR = "administrator";
    public static final String FLD_VACC_AGAINST = "vaccAgainst";
    public static final String SIDE = "Side";

    static {
        Vaccination.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATIENT_ID, FLD_ARTIKEL_REF, FLD_BUSS_NAME, FLD_EAN, FLD_ATCCODE, FLD_LOT_NO, FLD_DOA, FLD_ADMINISTRATOR, FLD_VACC_AGAINST, "ExtInfo"});
    }

    Vaccination() {
    }

    protected Vaccination(String id) {
        super(id);
    }

    public static Vaccination load(String id) {
        return new Vaccination(id);
    }

    public Vaccination(String patientId, Artikel a, Date doa, String lotNo, String mandantId) {
        this(patientId, a.storeToString(), a.getLabel(), a.getEAN(), a.getATC_code(), doa, lotNo, mandantId);
    }

    public Vaccination(String patientId, String articleStoreToString, String articleLabel, String articleEAN, String articleATCCode, Date doa, String lotNo, String mandantId) {
        this(patientId, articleStoreToString, articleLabel, articleEAN, articleATCCode, new TimeTool(doa).toString(9), lotNo, mandantId);
    }

    public Vaccination(String patientId, String articleStoreToString, String articleLabel, String articleEAN, String articleATCCode, String doa, String lotNo, String mandantId) {
        this.create(null);
        String vaccAgainst = "";
        if (articleATCCode != null) {
            vaccAgainst = StringUtils.join(ArticleToImmunisationModel.getImmunisationForAtcCode(articleATCCode), (String)",");
        }
        String[] fields = new String[]{FLD_PATIENT_ID, FLD_ARTIKEL_REF, FLD_BUSS_NAME, FLD_EAN, FLD_ATCCODE, FLD_LOT_NO, FLD_DOA, FLD_ADMINISTRATOR, FLD_VACC_AGAINST};
        String[] vals = new String[]{patientId, articleStoreToString, articleLabel, articleEAN, articleATCCode, lotNo, doa, mandantId, vaccAgainst};
        this.set(fields, vals);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getLabel() {
        return this.getDateOfAdministration().toString(9) + " " + this.getBusinessName() + " (" + this.getLotNo() + ") - " + this.getAdministratorLabel();
    }

    public TimeTool getDateOfAdministration() {
        return new TimeTool(this.get(FLD_DOA));
    }

    public void setDateOfAdministration(Date tt) {
        TimeTool ttd = new TimeTool(tt);
        this.set(FLD_DOA, ttd.toString(9));
    }

    public String getDateOfAdministrationLabel() {
        String doa = this.get(FLD_DOA);
        if (doa.endsWith("0000")) {
            return doa.substring(0, doa.length() - 4);
        }
        TimeTool ttDoA = new TimeTool(doa);
        return ttDoA.toString(4);
    }

    public String getBusinessName() {
        return this.get(FLD_BUSS_NAME);
    }

    public String getShortBusinessName() {
        String businessName = this.get(FLD_BUSS_NAME);
        if (businessName.contains("(")) {
            return businessName.substring(0, businessName.indexOf("("));
        }
        return businessName;
    }

    public String getLotNo() {
        return this.get(FLD_LOT_NO);
    }

    public String getAtcCode() {
        return this.get(FLD_ATCCODE);
    }

    public String getPatientId() {
        return this.get(FLD_PATIENT_ID);
    }

    @NonNull
    public String getAdministratorLabel() {
        String value = this.get(FLD_ADMINISTRATOR);
        if (value.startsWith("ch.elexis")) {
            Mandant mandant = this.loadMandant(value);
            if (mandant == null) {
                return "";
            }
            String title = Person.load((String)mandant.getId()).get("Titel");
            if (title == null || title.isEmpty()) {
                return mandant.getName() + " " + mandant.getVorname();
            }
            return title + " " + mandant.getName() + " " + mandant.getVorname();
        }
        if (value == null || value.length() < 2) {
            return "";
        }
        return value;
    }

    private Mandant loadMandant(String value) {
        Optional mandator = StoreToStringServiceHolder.get().loadFromString(value);
        if (mandator.isPresent()) {
            return Mandant.load((String)((Identifiable)mandator.get()).getId());
        }
        return null;
    }

    public boolean isSupplement() {
        Mandant mandant;
        String value = this.get(FLD_ADMINISTRATOR);
        return !value.startsWith(Mandant.class.getName()) && !value.startsWith(Person.class.getName()) || (mandant = this.loadMandant(value)) == null;
    }

    public static List<Vaccination> findByLotNo(String lotNo) {
        Query qbe = new Query(Vaccination.class);
        qbe.clear(true);
        qbe.add(FLD_LOT_NO, "=", lotNo);
        return qbe.execute();
    }

    public void setVaccAgainst(String vaccAgainst) {
        this.set(FLD_VACC_AGAINST, vaccAgainst);
    }

    public List<String> getVaccAgainstList() {
        String[] split;
        ArrayList<String> vaccAgainst = new ArrayList<String>();
        String vaccAgaisntString = this.get(FLD_VACC_AGAINST);
        String[] stringArray = split = vaccAgaisntString.split(",");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String va = stringArray[n2];
            vaccAgainst.add(va);
            ++n2;
        }
        return vaccAgainst;
    }

    public void setAdministratorString(String administrator) {
        this.set(FLD_ADMINISTRATOR, administrator);
    }

    public void setLotNo(String lotNo) {
        this.set(FLD_LOT_NO, lotNo);
    }

    public String getSide() {
        return Vaccination.checkNull((Object)this.getExtInfoStoredObjectByKey(SIDE));
    }

    public void setSide(String side) {
        this.setExtInfoStoredObjectByKey(SIDE, side);
    }
}

