/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.model.vaccplans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractVaccinationPlan {
    public final String name;
    public final String id;
    public final List<RequiredVaccination> baseVaccinations;
    public final List<RequiredVaccination> extendedVaccinations;

    public AbstractVaccinationPlan(String id, String name) {
        this.name = name;
        this.id = id;
        this.initialize();
        this.baseVaccinations = Collections.unmodifiableList(this.addBaseVaccinations(new ArrayList<RequiredVaccination>()));
        this.extendedVaccinations = Collections.unmodifiableList(this.addExtendedVaccinations(new ArrayList<RequiredVaccination>()));
    }

    protected abstract void initialize();

    protected abstract List<RequiredVaccination> addBaseVaccinations(List<RequiredVaccination> var1);

    protected abstract List<RequiredVaccination> addExtendedVaccinations(List<RequiredVaccination> var1);

    public abstract List<String> getOrderedBaseDiseases();

    public abstract List<String> getOrderedExtendedDiseases();

    public static class RequiredVaccination {
        public final int beginAgeInMonths;
        public final int endAgeInMonths;
        public final String diseaseAtcCode;

        public RequiredVaccination(int beginAgeInMonths, int endAgeInMonths, String diseaseAtcCode) {
            this.beginAgeInMonths = beginAgeInMonths;
            this.endAgeInMonths = endAgeInMonths;
            this.diseaseAtcCode = diseaseAtcCode;
        }

        public String toString() {
            return "(" + this.beginAgeInMonths + ")-(" + this.endAgeInMonths + "): " + this.getClearedDiseaseAtcCode();
        }

        public String getClearedDiseaseAtcCode() {
            return this.diseaseAtcCode.replaceAll("/[BbEe]$", "");
        }
    }
}

