/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.preferences;

import at.medevit.elexis.impfplan.ui.VaccinationView;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.wb.swt.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Logger log = LoggerFactory.getLogger(PreferencePage.class);
    public static final String ID = "at.medevit.elexis.impfplan.ui.preferences";
    public static final String PREFBASE = "plugins/impfplan/";
    public static final String VAC_PDF_OUTPUTDIR = "plugins/impfplan/outputdir";
    public static final String VAC_SORT_ORDER = "plugins/impfplan/sortorder";
    public static final String VAC_BILLING_POS = "plugins/impfplan/defleistungen";
    public static final String VAC_SHOW_SIDE = "plugins/impfplan/showside";
    public static final String VAC_AUTO_BILL = "plugins/impfplan/autobill";
    public static final String VAC_DEFAULT_SIDE = "plugins/impfplan/defaultside";
    private Text txtLog;
    private Label lblInfo;
    private Button btnImport;
    private boolean visibleImportPart;

    public PreferencePage() {
        try {
            Class<?> formerVaccClass = Class.forName("ch.elexis.impfplan.model.Vaccination");
            this.visibleImportPart = true;
        }
        catch (ClassNotFoundException e1) {
            log.debug("ch.elexis.impfplan Plugin not present - disable import in preferences");
            this.visibleImportPart = false;
        }
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER));
        this.getPreferenceStore().setDefault(VAC_AUTO_BILL, true);
    }

    protected void createFieldEditors() {
        DirectoryFieldEditor editor = new DirectoryFieldEditor(VAC_PDF_OUTPUTDIR, "Druck-Ausgabeverzeichnis", this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
        BooleanFieldEditor bfAutoBillEditor = new BooleanFieldEditor(VAC_AUTO_BILL, "Impfungen automatisch mit Position 00.0010 verrechnen", this.getFieldEditorParent());
        this.addField((FieldEditor)bfAutoBillEditor);
        BooleanFieldEditor bfEditor = new BooleanFieldEditor(VAC_SORT_ORDER, "Sortierung von neu-alt (neueste oben)", this.getFieldEditorParent());
        this.addField((FieldEditor)bfEditor);
        BooleanFieldEditor bfShowSideEditor = new BooleanFieldEditor(VAC_SHOW_SIDE, "Seite (auf welcher geimpft wurde) einblenden", this.getFieldEditorParent());
        this.addField((FieldEditor)bfShowSideEditor);
        RadioGroupFieldEditor radioGroup = new RadioGroupFieldEditor(VAC_DEFAULT_SIDE, "Standard Seite (nur relevant, wenn Seite einblenden aktiv ist)", 2, (String[][])new String[][]{{"links", "left"}, {"rechts", "right"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)radioGroup);
        Composite area = new Composite(this.getFieldEditorParent().getParent(), 0);
        area.setLayoutData((Object)new GridData(1808));
        area.setLayout((Layout)new GridLayout(1, false));
        this.lblInfo = new Label(area, 0);
        this.lblInfo.setText("Um Impfungen aus dem fr\u00fcherem Impfplan zu importieren dr\u00fccken Sie 'Import starten'");
        this.btnImport = new Button(area, 8);
        this.btnImport.setImage(ResourceManager.getPluginImage("at.medevit.elexis.impfplan.ui", "rsc/icons/start_task.png"));
        this.btnImport.setText("Import starten");
        this.btnImport.setToolTipText("Impfungen aus anderem Impflan importieren");
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    Object returnMsg = handlerService.executeCommand("at.medevit.elexis.impfplan.ui.command.ImportOtherVaccinations", null);
                    if (returnMsg != null) {
                        PreferencePage.this.txtLog.setText((String)returnMsg);
                    }
                }
                catch (Exception ex) {
                    log.error("Exception while trying to execute command: at.medevit.elexis.impfplan.ui.command.ImportOtherVaccinations", (Throwable)ex);
                    SWTHelper.showError((String)"Fehler", (String)"Fehler beim Versuch den Impf-Import auszuf\u00fchren!");
                }
            }
        });
        this.txtLog = new Text(area, 2826);
        this.txtLog.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.txtLog.setText("Import log...");
        this.setImportFieldVisibility();
    }

    private void setImportFieldVisibility() {
        this.lblInfo.setVisible(this.visibleImportPart);
        this.btnImport.setVisible(this.visibleImportPart);
        this.txtLog.setVisible(this.visibleImportPart);
    }

    public boolean performOk() {
        VaccinationView vaccView = (VaccinationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("at.medevit.elexis.impfplan.ui.ImpfplanViewPart");
        if (vaccView != null) {
            vaccView.updateUi(true);
        }
        return super.performOk();
    }
}

