/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class GraphicsUtil {
    public static void drawVerticalText(String string, Display display, int x, int y, GC gc, int style) {
        if (display == null) {
            SWT.error((int)22);
        }
        Point pt = gc.textExtent(string);
        Image stringImage = new Image((Device)display, pt.x, pt.y);
        GC stringGc = new GC((Drawable)stringImage);
        stringGc.setForeground(gc.getForeground());
        stringGc.setBackground(gc.getBackground());
        stringGc.setFont(gc.getFont());
        stringGc.drawText(string, 0, 0);
        GraphicsUtil.drawVerticalImage(stringImage, display, x, y, gc, style);
        stringGc.dispose();
        stringImage.dispose();
    }

    public static void drawVerticalImage(Image image, Display display, int x, int y, GC gc, int style) {
        boolean bottom;
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        boolean up = (style & 0x80) == 128;
        int sx = 0;
        while (sx < sd.width) {
            int sy = 0;
            while (sy < sd.height) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        Image vertical = new Image((Device)display, dd);
        boolean bl = bottom = (style & 0x400) == 1024;
        if (bottom) {
            gc.drawImage(vertical, x, y - vertical.getImageData().height);
        } else {
            gc.drawImage(vertical, x, y);
        }
        vertical.dispose();
    }
}

