/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.tools;

import at.medevit.elexis.gdt.constants.GDTConstants;
import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.messages.GDTSatzNachricht;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.Log;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class GDTFileHelper {
    private static Log logger = Log.get((String)GDTFileHelper.class.getName());
    static DecimalFormat threePlaces = new DecimalFormat("000");

    public static boolean containsSatzNachricht(File file) {
        List contents;
        block3: {
            try {
                contents = FileUtils.readLines((File)file);
                if (contents.size() != 0) break block3;
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return ((String)contents.get(0)).substring(3, 7).equalsIgnoreCase("8000");
    }

    public static <U extends GDTSatzNachricht> boolean writeGDTSatzNachricht(U gdtSatzNachricht, IGDTCommunicationPartner cp) {
        String[] outLines = gdtSatzNachricht.getMessage();
        String zeichensatz = GDTConstants.getCharsetStringByInt(cp.getOutgoingDefaultCharset());
        String directory = cp.getOutgoingDirectory();
        String outgoingFileName = GDTFileHelper.determineOutgoingFileName(cp);
        try {
            File destination = new File(directory + File.separatorChar + outgoingFileName);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < outLines.length) {
                sb.append(outLines[i]);
                ++i;
            }
            FileUtils.writeStringToFile((File)destination, (String)sb.toString(), (String)zeichensatz);
        }
        catch (IOException e) {
            String message = "GDT: Fehler beim Schreiben der Ausgangsdatei " + outgoingFileName;
            Status status = new Status(2, "at.medevit.elexis.gdt", message, (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 2);
            logger.log((Throwable)e, message, 3);
            return false;
        }
        return true;
    }

    public static String determineOutgoingFileName(IGDTCommunicationPartner cp) {
        String directory = cp.getOutgoingDirectory();
        String filenameHeader = cp.getShortIDReceiver() + CoreHub.localCfg.get("GDT/fileTransferKuerzelID", "ELXS");
        Object filename = null;
        if (cp.getRequiredFileType().equalsIgnoreCase("fest")) {
            filename = cp.getFixedCommmunicationFileName() != null ? cp.getFixedCommmunicationFileName() : filenameHeader + ".GDT";
        } else if (cp.getRequiredFileType().equalsIgnoreCase("hochzaehlend")) {
            File file;
            int counter = 0;
            while ((file = new File(directory + File.separatorChar + (String)(filename = filenameHeader + "." + threePlaces.format(counter)))).exists()) {
                ++counter;
            }
        } else {
            logger.log("Invalid file transfer type returned, neither fest nor hochzaehlend!", 2);
        }
        return filename;
    }
}

