/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.ui.table.util;

import at.medevit.elexis.gdt.ui.table.util.IValue;
import at.medevit.elexis.gdt.ui.table.util.IValueFormatter;
import at.medevit.elexis.gdt.ui.table.util.PropertyValue;
import at.medevit.elexis.gdt.ui.table.util.SortColumnComparator;
import at.medevit.elexis.gdt.ui.table.util.StringValueFormatter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ColumnBuilder {
    private final TableViewer viewer;
    private final String columnHeaderText;
    private IValue valueHandler;
    private IValueFormatter valueFormatter;
    private ICellFormatter cellFormatter;
    private CellLabelProvider customLabelProvider;
    private Integer widthPixel;
    private Integer widthPercent;
    private int align = 16384;
    private CellEditor editor;
    private IValue sortBy;
    private boolean defaultSort;
    private IValueFormatter editorFormat;

    public ColumnBuilder(TableViewer viewer, String columnHeaderText) {
        this.viewer = viewer;
        this.columnHeaderText = columnHeaderText;
    }

    public ColumnBuilder bindToProperty(String propertyName) {
        return this.bindToValue(new PropertyValue(propertyName));
    }

    public ColumnBuilder bindToValue(IValue valueHandler) {
        this.valueHandler = valueHandler;
        return this;
    }

    public ColumnBuilder format(IValueFormatter valueFormatter) {
        this.valueFormatter = valueFormatter;
        return this;
    }

    public ColumnBuilder format(ICellFormatter cellFormatter) {
        this.cellFormatter = cellFormatter;
        return this;
    }

    public ColumnBuilder setCustomLabelProvider(CellLabelProvider customLabelProvider) {
        this.customLabelProvider = customLabelProvider;
        return this;
    }

    public ColumnBuilder setPercentWidth(int width) {
        this.widthPercent = width;
        return this;
    }

    public ColumnBuilder setPixelWidth(int width) {
        this.widthPixel = width;
        return this;
    }

    public ColumnBuilder alignCenter() {
        this.align = 0x1000000;
        return this;
    }

    public ColumnBuilder alignRight() {
        this.align = 131072;
        return this;
    }

    public ColumnBuilder makeEditable() {
        return this.makeEditable((CellEditor)new TextCellEditor((Composite)this.viewer.getTable()), StringValueFormatter.INSTANCE);
    }

    public ColumnBuilder makeEditable(IValueFormatter valueFormatter) {
        return this.makeEditable((CellEditor)new TextCellEditor((Composite)this.viewer.getTable()), valueFormatter);
    }

    public ColumnBuilder makeEditable(CellEditor cellEditor) {
        return this.makeEditable(cellEditor, null);
    }

    public ColumnBuilder makeEditable(CellEditor cellEditor, IValueFormatter valueFormatter) {
        if (cellEditor.getControl().getParent() != this.viewer.getTable()) {
            throw new RuntimeException("Parent of cell editor needs to be the table!");
        }
        this.editor = cellEditor;
        this.editorFormat = valueFormatter;
        return this;
    }

    public ColumnBuilder sortBy(IValue sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public ColumnBuilder useAsDefaultSortColumn() {
        this.defaultSort = true;
        return this;
    }

    public TableViewerColumn build() {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, this.align);
        TableColumn column = viewerColumn.getColumn();
        column.setText(this.columnHeaderText);
        if (this.customLabelProvider != null) {
            if (this.cellFormatter != null) {
                throw new RuntimeException("If you specify a custom label provider, it is not allowed to specify a cell formatter. You need to do the formatting in your labelprovider!");
            }
            viewerColumn.setLabelProvider(this.customLabelProvider);
        } else {
            viewerColumn.setLabelProvider((CellLabelProvider)new PropertyCellLabelProvider(this.valueHandler, this.valueFormatter, this.cellFormatter));
        }
        if (this.sortBy == null) {
            this.sortBy = this.valueHandler;
        }
        if (this.sortBy != null) {
            column.setData(SortColumnComparator.SORT_BY, (Object)this.sortBy);
            column.addSelectionListener((SelectionListener)new ColumnSortSelectionListener(this.viewer));
            if (this.defaultSort) {
                this.viewer.getTable().setSortColumn(column);
                this.viewer.getTable().setSortDirection(128);
            }
        }
        if (this.widthPixel != null && this.widthPercent != null) {
            throw new RuntimeException("You can specify a width in pixel OR in percent, but not both!");
        }
        if (this.widthPercent == null) {
            ((TableColumnLayout)this.viewer.getTable().getParent().getLayout()).setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(this.widthPixel == null ? 100 : this.widthPixel));
        } else {
            ((TableColumnLayout)this.viewer.getTable().getParent().getLayout()).setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(this.widthPercent.intValue()));
        }
        if (this.editor != null) {
            if (this.valueHandler == null) {
                throw new RuntimeException("makeEditable() requires that the column is bound to some value using bindTo...()");
            }
            viewerColumn.setEditingSupport((EditingSupport)new PropertyEditingSupport((ColumnViewer)this.viewer, this.valueHandler, this.editorFormat, this.editor));
        }
        return viewerColumn;
    }

    public class ColumnSortSelectionListener
    extends SelectionAdapter {
        private final TableViewer viewer;

        public ColumnSortSelectionListener(TableViewer viewer) {
            this.viewer = viewer;
        }

        public void widgetSelected(SelectionEvent e) {
            Table table;
            boolean alreadyActiveSortColumn;
            TableColumn column = (TableColumn)e.getSource();
            boolean bl = alreadyActiveSortColumn = column == (table = column.getParent()).getSortColumn();
            if (alreadyActiveSortColumn) {
                table.setSortDirection(table.getSortDirection() == 1024 ? 128 : 1024);
            } else {
                table.setSortColumn(column);
                table.setSortDirection(128);
            }
            this.viewer.refresh();
        }
    }

    public static interface ICellFormatter {
        public void formatCell(ViewerCell var1, Object var2);
    }

    public class PropertyCellLabelProvider
    extends CellLabelProvider {
        private final IValue valueHandler;
        private IValueFormatter valueFormatter;
        private final ICellFormatter cellFormatter;

        public PropertyCellLabelProvider(String propertyName) {
            this.valueHandler = new PropertyValue(propertyName);
            this.cellFormatter = null;
        }

        public PropertyCellLabelProvider(IValue valueHandler, IValueFormatter valueFormatter, ICellFormatter cellFormatter) {
            this.valueHandler = valueHandler;
            this.valueFormatter = valueFormatter;
            this.cellFormatter = cellFormatter;
        }

        public void update(ViewerCell cell) {
            try {
                Object rawValue = null;
                if (this.valueHandler != null) {
                    Object formattedValue = rawValue = this.valueHandler.getValue(cell.getElement());
                    if (this.valueFormatter != null) {
                        formattedValue = this.valueFormatter.format(rawValue);
                    }
                    cell.setText(String.valueOf(formattedValue));
                }
                if (this.cellFormatter != null) {
                    this.cellFormatter.formatCell(cell, rawValue);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public class PropertyEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final IValue valueHandler;
        private final IValueFormatter valueFormatter;

        public PropertyEditingSupport(ColumnViewer viewer, String propertyName, CellEditor cellEditor) {
            this(viewer, new PropertyValue(propertyName), null, cellEditor);
        }

        public PropertyEditingSupport(ColumnViewer viewer, IValue valueHandler, IValueFormatter valueFormatter, CellEditor cellEditor) {
            super(viewer);
            this.valueHandler = valueHandler;
            this.valueFormatter = valueFormatter;
            this.cellEditor = cellEditor;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            try {
                Object value = this.valueHandler.getValue(element);
                if (this.valueFormatter != null) {
                    value = this.valueFormatter.format(value);
                }
                return value;
            }
            catch (Exception e) {
                return null;
            }
        }

        protected void setValue(Object element, Object value) {
            try {
                Object parsedValue = value;
                if (this.valueFormatter != null) {
                    parsedValue = this.valueFormatter.parse(value);
                }
                this.valueHandler.setValue(element, parsedValue);
                this.getViewer().refresh();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

