/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.handler;

import at.medevit.elexis.gdt.handler.GDTInputHandler;
import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.tools.GDTCommPartnerCollector;
import at.medevit.elexis.gdt.tools.GDTSatzNachrichtHelper;
import ch.elexis.core.ui.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class GDTFileInputHandler {
    private static Log logger = Log.get((String)GDTFileInputHandler.class.getName());

    public static void handle(File file) {
        IGDTCommunicationPartner cp;
        String[] lines = GDTFileInputHandler.readFileGetUTF8(file);
        int satzkennung = 0;
        if (lines != null) {
            String satzkennungString = GDTSatzNachrichtHelper.getValueIfExists(8000, lines);
            satzkennung = Integer.parseInt(satzkennungString);
        }
        if ((cp = GDTCommPartnerCollector.identifyCommunicationPartnerByIncomingDirectory(file.getParent())) == null) {
            logger.log("IGDTCommunicationPartner for file " + file.getAbsolutePath() + " is null, skipping.", 2);
            return;
        }
        boolean delivered = false;
        switch (satzkennung) {
            case 6300: {
                delivered = GDTInputHandler.handleSatznachricht6300(lines, file.getName(), cp);
                if (!delivered) break;
                GDTFileInputHandler.delete(file);
                break;
            }
            case 6310: {
                delivered = GDTInputHandler.handleSatznachricht6310(lines, file.getName(), cp);
                if (!delivered) break;
                GDTFileInputHandler.delete(file);
                break;
            }
            case 6311: {
                GDTInputHandler.handleSatznachricht6311(lines, file.getName(), cp);
                break;
            }
            case 6301: {
                GDTInputHandler.handleSatznachricht6301(lines, file.getName(), cp);
                break;
            }
            case 6302: {
                GDTInputHandler.handleSatznachricht6302(lines, file.getName(), cp);
            }
        }
    }

    private static void delete(File file) {
        try {
            boolean deleted = file.delete();
            if (deleted) {
                logger.log("Deleted " + file.getAbsolutePath(), 5);
            } else {
                logger.log("Error deleting " + file.getAbsolutePath(), 3);
            }
        }
        catch (SecurityException e) {
            logger.log((Throwable)e, "Error deleting " + file.getAbsolutePath(), 3);
        }
    }

    public static String[] readFileGetUTF8(File file) {
        int encoding = 2;
        try {
            List dataList = FileUtils.readLines((File)file, (String)"cp437");
            String[] data = dataList.toArray(new String[0]);
            String usedEncoding = GDTSatzNachrichtHelper.getValueIfExists(9206, data);
            if (usedEncoding == null) {
                return data;
            }
            int usedEncodingInt = Integer.parseInt(usedEncoding);
            if (encoding == usedEncodingInt) {
                return data;
            }
            if (usedEncodingInt == 1) {
                return FileUtils.readLines((File)file, (String)"US-ASCII").toArray(new String[0]);
            }
            if (usedEncodingInt == 3) {
                return FileUtils.readLines((File)file, (String)"Cp1252").toArray(new String[0]);
            }
        }
        catch (IOException e) {
            String message = "GDT: Ein-/Ausgabe Fehler beim Lesen von " + file.getAbsolutePath();
            Status status = new Status(2, "at.medevit.elexis.gdt", message, (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 2);
            logger.log((Throwable)e, message, 3);
        }
        return null;
    }
}

