/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.tools;

import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartnerProvider;
import ch.elexis.core.jdt.Nullable;
import ch.rgw.tools.Log;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class GDTCommPartnerCollector {
    private static Log logger = Log.get((String)GDTCommPartnerCollector.class.getName());
    public static final String EP_ID = "at.medevit.elexis.gdt.communicationPartner";

    @Nullable
    public static List<IGDTCommunicationPartner> getRegisteredCommPartners() {
        LinkedList<IGDTCommunicationPartner> ret = null;
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EP_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("interface");
                if (o instanceof IGDTCommunicationPartner) {
                    if (ret == null) {
                        ret = new LinkedList<IGDTCommunicationPartner>();
                    }
                    ret.add((IGDTCommunicationPartner)o);
                }
                if (o instanceof IGDTCommunicationPartnerProvider) {
                    if (ret == null) {
                        ret = new LinkedList();
                    }
                    ret.addAll(((IGDTCommunicationPartnerProvider)o).getChildCommunicationPartners());
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            logger.log("CoreException in getRegisteredCommPartners: " + ex.getMessage(), 3);
            System.out.println(ex.getMessage());
        }
        if (ret == null) {
            return null;
        }
        return ret;
    }

    @Nullable
    public static IGDTCommunicationPartner identifyCommunicationPartnerByIncomingDirectory(String incomingDirectory) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EP_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IGDTCommunicationPartner cp;
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("interface");
                if (o instanceof IGDTCommunicationPartner && (cp = (IGDTCommunicationPartner)o) != null && cp.getIncomingDirectory() != null && cp.getIncomingDirectory().equalsIgnoreCase(incomingDirectory)) {
                    return cp;
                }
                if (o instanceof IGDTCommunicationPartnerProvider) {
                    LinkedList childPartners = new LinkedList();
                    for (IGDTCommunicationPartner igdtCommunicationPartner : childPartners) {
                        if (!igdtCommunicationPartner.getIncomingDirectory().equalsIgnoreCase(incomingDirectory)) continue;
                        return igdtCommunicationPartner;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            logger.log("CoreException in getRegisteredCommPartners: " + ex.getMessage(), 3);
            System.out.println(ex.getMessage());
        }
        return null;
    }

    @Nullable
    public static IGDTCommunicationPartner identifyCommunicationPartnerByLabel(String label) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EP_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IGDTCommunicationPartner cp;
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("interface");
                if (o instanceof IGDTCommunicationPartner && (cp = (IGDTCommunicationPartner)o).getLabel().equalsIgnoreCase(label)) {
                    return cp;
                }
                if (o instanceof IGDTCommunicationPartnerProvider) {
                    LinkedList childPartners = new LinkedList();
                    for (IGDTCommunicationPartner igdtCommunicationPartner : childPartners) {
                        if (!igdtCommunicationPartner.getLabel().equalsIgnoreCase(label)) continue;
                        return igdtCommunicationPartner;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            logger.log("CoreException in getRegisteredCommPartners: " + ex.getMessage(), 3);
            System.out.println(ex.getMessage());
        }
        return null;
    }
}

