/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.defaultfilecp;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.activator.CoreHubHelper;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;

public class FileCommPartner {
    public static final String DEFAULT_COMM_PARTNER_ID = "DEFAULT";
    private static final String CFG_GDT = "GDT";
    private static final String FILETRANSFER_NAME = "fileTransferName";
    private static final String FILETRANSFER_USED_TYPE = "fileTransferUsedType";
    private static final String FILETRANSFER_DIRECTORY = "fileTransferDirectory";
    private static final String FILETRANSFER_IN_DIRECTORY = "fileTransferInDirectory";
    private static final String FILETRANSFER_OUT_DIRECTORY = "fileTransferOutDirectory";
    private static final String FILETRANSFER_LONG_ID_RECEIVER = "longIDReceiver";
    private static final String FILETRANSFER_SHORT_ID_RECEIVER = "longIDReceiver";
    private static final String FILETRANSFER_EXECUTABLE = "executable";
    private static final String FILETRANSFER_EXECUTABLE_WAIT = "executableWait";
    private static final String FILETRANSFER_VIEWEREXECUTABLE = "viewerexecutable";
    private static final String FILETRANSFER_ADDITIONAL_PARAMS = "additionalParams";
    private static final String FILETRANSFER_GUVK_DEFAULT = "guvkDefault";
    public static final String CFG_GDT_FILETRANSFER_IDS = "GDT/fileTransferTypes";
    private static final String CFG_GDT_FILETRANSFER_GLOBAL = "GDTfileTransferSettingsGlobal";
    public static final String COMM_PARTNER_SEPERATOR = ",;,";
    private String id;
    private final ConfigServicePreferenceStore preferenceStore;
    public static String[][] comboCharsetSelektor = new String[][]{{"7Bit", "US-ASCII"}, {"IBM (Standard) CP 437", "cp437"}, {"ISO8859-1 (ANSI) CP 1252", "Cp1252"}};

    public FileCommPartner() {
        this(DEFAULT_COMM_PARTNER_ID);
    }

    public FileCommPartner(String id) {
        this.id = id;
        this.preferenceStore = new ConfigServicePreferenceStore(FileCommPartner.isFileTransferGlobalConfigured() ? ConfigServicePreferenceStore.Scope.GLOBAL : ConfigServicePreferenceStore.Scope.LOCAL);
        if (DEFAULT_COMM_PARTNER_ID.equals(id) && !FileCommPartner.isFileTransferGlobalConfigured()) {
            CoreHubHelper.transformConfigKey((String)"GDT/defaultfilecp/fileTransferDirectory", (String)this.getFileTransferDirectory(), (boolean)false);
            CoreHubHelper.transformConfigKey((String)"GDT/defaultfilecp/fileTransferDirectory", (String)this.getFileTransferInDirectory(), (boolean)false);
            CoreHubHelper.transformConfigKey((String)"GDT/defaultfilecp/fileTransferDirectory", (String)this.getFileTransferOutDirectory(), (boolean)false);
            CoreHubHelper.transformConfigKey((String)"GDT/defaultfilecp/fileTransferUsedType", (String)this.getFileTransferUsedType(), (boolean)false);
            CoreHubHelper.transformConfigKey((String)"GDT/defaultfilecp/longIDReceiver", (String)this.getFileTransferIdReceiver(), (boolean)false);
            CoreHubHelper.transformConfigKey((String)"GDT/defaultfilecp/executable", (String)this.getFileTransferExecuteable(), (boolean)false);
        }
        this.getSettings().setDefault(this.getFileTransferExecuteableWait(), Boolean.TRUE.booleanValue());
    }

    public String getFileTransferName() {
        return "GDT/" + this.getId() + "/fileTransferName";
    }

    public String getFileTransferUsedType() {
        return "GDT/" + this.getId() + "/fileTransferUsedType";
    }

    public String getFileTransferDirectory() {
        return "GDT/" + this.getId() + "/fileTransferDirectory";
    }

    public String getFileTransferInDirectory() {
        return "GDT/" + this.getId() + "/fileTransferInDirectory";
    }

    public String getFileTransferOutDirectory() {
        return "GDT/" + this.getId() + "/fileTransferOutDirectory";
    }

    public String getFileTransferIdReceiver() {
        return "GDT/" + this.getId() + "/longIDReceiver";
    }

    public String getFileTransferShortIdReceiver() {
        return "GDT/" + this.getId() + "/longIDReceiver";
    }

    public String getFileTransferExecuteable() {
        return "GDT/" + this.getId() + "/executable";
    }

    public String getFileTransferViewerExecuteable() {
        return "GDT/" + this.getId() + "/viewerexecutable";
    }

    public String getFileAdditionalParams() {
        return "GDT/" + this.getId() + "/additionalParams";
    }

    public String getFileTransferExecuteableWait() {
        return "GDT/" + this.getId() + "/executableWait";
    }

    public String getGuvkDefault() {
        return "GDT/" + this.getId() + "/guvkDefault";
    }

    public String getId() {
        return this.id;
    }

    public static boolean isFileTransferGlobalConfigured() {
        return ConfigServiceHolder.getGlobal((String)CFG_GDT_FILETRANSFER_GLOBAL, (boolean)false);
    }

    public static void setFileTransferConfiguration(boolean global) {
        ConfigServiceHolder.setGlobal((String)CFG_GDT_FILETRANSFER_GLOBAL, (boolean)global);
    }

    public static String[] getAllFileCommPartnersArray() {
        if (FileCommPartner.isFileTransferGlobalConfigured()) {
            return ConfigServiceHolder.getGlobal((String)CFG_GDT_FILETRANSFER_IDS, (String)DEFAULT_COMM_PARTNER_ID).split(COMM_PARTNER_SEPERATOR);
        }
        return CoreHub.localCfg.get(CFG_GDT_FILETRANSFER_IDS, DEFAULT_COMM_PARTNER_ID).split(COMM_PARTNER_SEPERATOR);
    }

    public IPreferenceStore getSettings() {
        return this.preferenceStore;
    }
}

