/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.gdt.defaultfilecp;

import at.medevit.elexis.gdt.constants.Feld8402Constants;
import at.medevit.elexis.gdt.constants.GDTConstants;
import at.medevit.elexis.gdt.defaultfilecp.FileCommPartner;
import at.medevit.elexis.gdt.interfaces.HandlerProgramType;
import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartner;
import at.medevit.elexis.gdt.interfaces.IGDTCommunicationPartnerProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class DefaultFileCommPartner
implements IGDTCommunicationPartnerProvider {
    private FileCommPartner defaultFileCommPartner = new FileCommPartner();

    public int getConnectionType() {
        return 2;
    }

    public String getConnectionString() {
        return null;
    }

    public String getLabel() {
        return this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferName()) + " (" + this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferDirectory()) + ")";
    }

    public String getIDReceiver() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferIdReceiver()), (CharSequence)"MEDICALDEVICE");
    }

    public String getShortIDReceiver() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferShortIdReceiver()), (CharSequence)"MDEV");
    }

    public String[] getSupported8402values() {
        String[] ret = Feld8402Constants.enumNameToStringArray((Enum[])Feld8402Constants.ALL.values());
        String defaultValue = this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getGuvkDefault());
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            String[] inclDefault = new String[ret.length + 1];
            inclDefault[0] = defaultValue;
            System.arraycopy(ret, 0, inclDefault, 1, ret.length);
            ret = inclDefault;
        }
        return ret;
    }

    public String[] getSupported8402valuesDescription() {
        String[] ret = Feld8402Constants.enumNameToStringArrayDescription((Enum[])Feld8402Constants.ALL.values());
        String defaultValue = this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getGuvkDefault());
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            String[] inclDefault = new String[ret.length + 1];
            inclDefault[0] = "";
            System.arraycopy(ret, 0, inclDefault, 1, ret.length);
            ret = inclDefault;
        }
        return ret;
    }

    public String[] getSupported8402valuesDetailDescription() {
        return null;
    }

    public String getDefault8402value() {
        return StringUtils.defaultString((String)this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getGuvkDefault()));
    }

    public String getRequiredFileType() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferUsedType()), (CharSequence)"hochzaehlend");
    }

    public String getIncomingDirectory() {
        return this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferInDirectory());
    }

    public String getOutgoingDirectory() {
        return this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferOutDirectory());
    }

    public int getIncomingDefaultCharset() {
        String charset = (String)StringUtils.defaultIfBlank((CharSequence)this.defaultFileCommPartner.getSettings().getString("GDT/Charset"), (CharSequence)"Cp1252");
        return GDTConstants.getCharsetIntByString((String)charset);
    }

    public int getOutgoingDefaultCharset() {
        String charset = (String)StringUtils.defaultIfBlank((CharSequence)this.defaultFileCommPartner.getSettings().getString("GDT/Charset"), (CharSequence)"Cp1252");
        return GDTConstants.getCharsetIntByString((String)charset);
    }

    public String getExternalHandlerProgram(HandlerProgramType handlerType) {
        String executable = null;
        executable = handlerType == HandlerProgramType.VIEWER ? this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferViewerExecuteable()) : this.defaultFileCommPartner.getSettings().getString(this.defaultFileCommPartner.getFileTransferExecuteable());
        LoggerFactory.getLogger(this.getClass()).info("Find external handler [" + executable + "] of [" + this.defaultFileCommPartner.getId() + "] in [" + this.defaultFileCommPartner.getSettings().getClass().getSimpleName() + "]");
        if (StringUtils.isNotBlank((CharSequence)executable)) {
            File execFile = new File(executable);
            if (execFile.canExecute()) {
                return executable;
            }
            LoggerFactory.getLogger(this.getClass()).warn("Can not execute external handler [" + executable + "]");
        }
        return null;
    }

    public Boolean getExternalHandlerProgramWait() {
        return this.defaultFileCommPartner.getSettings().getBoolean(this.defaultFileCommPartner.getFileTransferExecuteableWait());
    }

    public String getFixedCommmunicationFileName() {
        return null;
    }

    public String getId() {
        return this.defaultFileCommPartner.getId();
    }

    public List<IGDTCommunicationPartner> getChildCommunicationPartners() {
        ArrayList<IGDTCommunicationPartner> communicationPartners = new ArrayList<IGDTCommunicationPartner>();
        final DefaultFileCommPartner parent = this;
        String[] stringArray = FileCommPartner.getAllFileCommPartnersArray();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!this.defaultFileCommPartner.getId().equals(id)) {
                final FileCommPartner fileCommPartner = new FileCommPartner(id);
                communicationPartners.add((IGDTCommunicationPartner)new IGDTCommunicationPartnerProvider(){

                    public String[] getSupported8402valuesDetailDescription() {
                        return parent.getSupported8402valuesDetailDescription();
                    }

                    public String[] getSupported8402valuesDescription() {
                        return parent.getSupported8402valuesDescription();
                    }

                    public String[] getSupported8402values() {
                        return parent.getSupported8402values();
                    }

                    public String getDefault8402value() {
                        return parent.getDefault8402value();
                    }

                    public String getShortIDReceiver() {
                        return (String)StringUtils.defaultIfBlank((CharSequence)DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferShortIdReceiver()), (CharSequence)"MDEV");
                    }

                    public String getRequiredFileType() {
                        return (String)StringUtils.defaultIfBlank((CharSequence)DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferUsedType()), (CharSequence)"hochzaehlend");
                    }

                    public String getOutgoingDirectory() {
                        return DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferOutDirectory());
                    }

                    public int getOutgoingDefaultCharset() {
                        return parent.getOutgoingDefaultCharset();
                    }

                    public String getLabel() {
                        return DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferName()) + " (" + DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferDirectory()) + ")";
                    }

                    public String getIncomingDirectory() {
                        return DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferInDirectory());
                    }

                    public int getIncomingDefaultCharset() {
                        return parent.getIncomingDefaultCharset();
                    }

                    public String getIDReceiver() {
                        return (String)StringUtils.defaultIfBlank((CharSequence)DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferIdReceiver()), (CharSequence)"MEDICALDEVICE");
                    }

                    public String getFixedCommmunicationFileName() {
                        return parent.getFixedCommmunicationFileName();
                    }

                    public String getExternalHandlerProgram(HandlerProgramType handlerType) {
                        String executable = null;
                        executable = handlerType == HandlerProgramType.VIEWER ? DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferViewerExecuteable()) : DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getString(fileCommPartner.getFileTransferExecuteable());
                        LoggerFactory.getLogger(this.getClass()).info("Find external handler [" + executable + "] of [" + fileCommPartner.getId() + "] in [" + DefaultFileCommPartner.this.defaultFileCommPartner.getSettings().getClass().getSimpleName() + "]");
                        if (StringUtils.isNotBlank((CharSequence)executable)) {
                            File execFile = new File(executable);
                            if (execFile.canExecute()) {
                                return executable;
                            }
                            LoggerFactory.getLogger(this.getClass()).warn("Can not execute external handler [" + executable + "]");
                        }
                        return null;
                    }

                    public int getConnectionType() {
                        return parent.getConnectionType();
                    }

                    public String getConnectionString() {
                        return parent.getConnectionString();
                    }

                    public List<IGDTCommunicationPartner> getChildCommunicationPartners() {
                        return Collections.emptyList();
                    }

                    public String getId() {
                        return fileCommPartner.getId();
                    }
                });
            }
            ++n2;
        }
        return communicationPartners;
    }
}

