/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.epha.interactions.utils;

import at.medevit.elexis.epha.interactions.api.EphaInteractionsApi;
import at.medevit.elexis.epha.interactions.api.model.AdviceResponse;
import at.medevit.elexis.epha.interactions.api.model.Substance;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EphaApiSearchAction
extends Action
implements IKonsExtension,
IHandler {
    public static final Logger logger = LoggerFactory.getLogger(EphaApiSearchAction.class);
    public static final String ID = "at.medevit.elexis.epha.interactions.EphaSearchAction";
    private static EphaApiSearchAction instance;
    private EphaInteractionsApi interactionsApi = new EphaInteractionsApi();

    public String connect(IRichTextDisplay tf) {
        return ID;
    }

    public EphaApiSearchAction() {
        super("Medikamenteninteraktion pr\u00fcfen ...");
    }

    public boolean doLayout(StyleRange n, String provider, String id) {
        return false;
    }

    public boolean doXRef(String refProvider, String refID) {
        return false;
    }

    public void run() {
        Optional patient = ContextServiceHolder.get().getActivePatient();
        if (patient.isPresent()) {
            List medication = ((IPatient)patient.get()).getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
            if (medication != null && !medication.isEmpty()) {
                Object ret = this.interactionsApi.advice(medication.stream().filter(p -> p.getArticle() != null).map(p -> Substance.of(p.getArticle())).collect(Collectors.toList()));
                if (ret instanceof AdviceResponse && ((AdviceResponse)ret).getData() != null) {
                    if (((AdviceResponse)ret).getData().getSafety() > 80) {
                        if (MessageDialog.open((int)2, (Shell)Display.getDefault().getActiveShell(), (String)"Epha", (String)this.getMessage((AdviceResponse)ret), (int)0x10000000, (String[])new String[]{"Epha Interaktionen \u00f6ffnen", IDialogConstants.OK_LABEL}) == 0) {
                            Program.launch((String)((AdviceResponse)ret).getData().getLink());
                        }
                    } else if (((AdviceResponse)ret).getData().getSafety() > 60) {
                        if (MessageDialog.open((int)4, (Shell)Display.getDefault().getActiveShell(), (String)"Epha", (String)this.getMessage((AdviceResponse)ret), (int)0x10000000, (String[])new String[]{"Epha Interaktionen \u00f6ffnen"}) == 0) {
                            Program.launch((String)((AdviceResponse)ret).getData().getLink());
                        }
                    } else if (MessageDialog.open((int)1, (Shell)Display.getDefault().getActiveShell(), (String)"Epha", (String)this.getMessage((AdviceResponse)ret), (int)0x10000000, (String[])new String[]{"Epha Interaktionen \u00f6ffnen"}) == 0) {
                        Program.launch((String)((AdviceResponse)ret).getData().getLink());
                    }
                } else if (ret instanceof AdviceResponse && ((AdviceResponse)ret).getMeta() != null) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Es ist folgender Fehler aufgetreten.\n\n" + ((AdviceResponse)ret).getMeta().getStatus() + " - " + ((AdviceResponse)ret).getMeta().getMessage()));
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Es ist folgender Fehler aufgetreten.\n\n" + String.valueOf(ret)));
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)"Der Patient hat keine fix Medikation");
            }
        } else {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)"Es ist kein Patient selektiert");
        }
    }

    private String getMessage(AdviceResponse response) {
        int safety = response.getData().getSafety();
        StringBuilder ret = new StringBuilder();
        if (safety > 80) {
            ret.append("Keine relevanten Einschr\u00e4nkung der Medikamentensicherheit");
        } else if (safety > 60) {
            ret.append("Erh\u00f6htes Risiko");
        } else {
            ret.append("Stark erh\u00f6htes Risiko");
        }
        if (response.getData().getValid() != null) {
            ret.append("\n\nEs wurden " + response.getData().getValid().size() + " Medikamente erfolgreich an epha \u00fcbertragen.");
        }
        if (response.getData().getFails() != null && !response.getData().getFails().isEmpty()) {
            List<Map<String, String>> fails = response.getData().getFails();
            ret.append("\n\nFolgende Medikamente konnten bei epha nicht gefunden werden:");
            for (Map<String, String> failMap : fails) {
                ICodeElement loaded;
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{failMap.get("name")})) {
                    ret.append("\n- " + failMap.get("name"));
                    continue;
                }
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{failMap.get("gtin")})) continue;
                ICodeElementServiceContribution artikelstammContribution = CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.ARTICLE, "Artikelstamm").orElse(null);
                if (artikelstammContribution != null && (loaded = (ICodeElement)artikelstammContribution.loadFromCode(failMap.get("gtin")).orElse(null)) != null) {
                    ret.append("\n- " + loaded.getText());
                    continue;
                }
                ret.append("\n- GTIN: " + failMap.get("gtin"));
            }
        }
        return ret.toString();
    }

    public IAction[] getActions() {
        return new IAction[]{this};
    }

    public void insert(Object o, int pos) {
    }

    public void removeXRef(String refProvider, String refID) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (instance != null) {
            instance.run();
        }
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

