/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.epha.interactions.api;

import at.medevit.elexis.epha.interactions.api.model.AdviceResponse;
import at.medevit.elexis.epha.interactions.api.model.Substance;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Response;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.LoggerFactory;

public class EphaInteractionsApi {
    private Client jaxrsClient = this.createJaxrsClient();
    private Gson gson = new GsonBuilder().create();

    public synchronized Object advice(List<Substance> model) {
        WebTarget target = this.jaxrsClient.target(this.getBaseUrl()).path("clinic/advice/" + Locale.getDefault().getLanguage() + "/");
        LoggerFactory.getLogger(this.getClass()).info("API target [" + String.valueOf(target) + "]");
        String jsonString = this.gson.toJson(model);
        jsonString = jsonString.replaceAll("/", " ");
        Response response = target.request().post(Entity.json((Object)jsonString));
        if (response.getStatus() >= 300) {
            String message = "[" + response.getStatus() + "]\n" + (String)response.readEntity(String.class);
            LoggerFactory.getLogger(this.getClass()).error(message);
            return message;
        }
        return response.readEntity(AdviceResponse.class);
    }

    private String getBaseUrl() {
        return "https://api.epha.health/";
    }

    private Client createJaxrsClient() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            return ClientBuilder.newBuilder().sslContext(sslcontext).hostnameVerifier((s1, s2) -> true).withConfig((Configuration)new ClientConfig()).build();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error creating jaxrs client", (Throwable)e);
            return null;
        }
    }
}

