/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.ui.handler;

import at.medevit.elexis.emediplan.core.EMediplanService;
import at.medevit.elexis.emediplan.core.EMediplanServiceHolder;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medicament;
import at.medevit.elexis.emediplan.core.model.chmed16a.Medication;
import at.medevit.elexis.emediplan.core.model.chmed16a.Posology;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectImportHandler
extends AbstractHandler
implements IHandler {
    private EMediplanService mediplanService;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.mediplanService = EMediplanServiceHolder.getService();
        String emediplan = event.getParameter("at.medevit.elexis.emediplan.ui.directImport.parameter.emediplan");
        String patientid = event.getParameter("at.medevit.elexis.emediplan.ui.directImport.parameter.patientid");
        String stopreason = event.getParameter("at.medevit.elexis.emediplan.ui.directImport.parameter.stopreason");
        String medicationType = event.getParameter("at.medevit.elexis.emediplan.ui.directImport.parameter.medication");
        if (medicationType == null || medicationType.isEmpty()) {
            medicationType = "all";
        }
        if (StringUtils.isNotEmpty((CharSequence)patientid) && StringUtils.isNotEmpty((CharSequence)emediplan)) {
            Medication medication = this.mediplanService.createModelFromChunk(emediplan);
            this.mediplanService.addExistingArticlesToMedication(medication);
            IPatient patient = CoreModelServiceHolder.get().load(patientid, IPatient.class).orElse(null);
            if (patient != null) {
                ContextServiceHolder.get().getRootContext().setTyped((Object)patient);
                List<IPrescription> currentMedication = this.getPrescriptions(patient, medicationType);
                LocalDateTime now = LocalDateTime.now();
                for (IPrescription prescription : currentMedication) {
                    MedicationServiceHolder.get().stopPrescription(prescription, now, stopreason != null ? stopreason : "Direct Import");
                    prescription.setDateTo(now);
                    CoreModelServiceHolder.get().save((Identifiable)prescription);
                }
                currentMedication.forEach(pr -> ContextServiceHolder.get().postEvent("info/elexis/model/update", pr));
                ArrayList<Medicament> notFoundMedicament = new ArrayList<Medicament>();
                for (Medicament medicament : medication.Medicaments) {
                    if (medicament.artikelstammItem != null) {
                        this.createPrescription(medicament, patient);
                        continue;
                    }
                    notFoundMedicament.add(medicament);
                }
                if (!notFoundMedicament.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Folgende Medikamente konnte im Artikelstamm nicht gefunden werden\n\n");
                    notFoundMedicament.forEach(m -> {
                        StringBuilder stringBuilder2 = sb.append(" - " + this.getDsc((Medicament)m) + " " + m.AppInstr + " " + m.TkgRsn);
                    });
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)sb.toString());
                }
            }
        }
        return null;
    }

    private String getDsc(Medicament medicament) {
        String ret = medicament.Id;
        if (StringUtils.isNotBlank((CharSequence)this.mediplanService.getPFieldValue(medicament, "Dsc"))) {
            ret = this.mediplanService.getPFieldValue(medicament, "Dsc");
        }
        return ret;
    }

    private List<IPrescription> getPrescriptions(IPatient patient, String medicationType) {
        if ("all".equals(medicationType)) {
            return patient.getMedication(Collections.emptyList());
        }
        if ("fix".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION));
        }
        if ("reserve".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.RESERVE_MEDICATION));
        }
        if ("symptomatic".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.SYMPTOMATIC_MEDICATION));
        }
        return Collections.emptyList();
    }

    private IPrescription createPrescription(Medicament medicament, IPatient patient) {
        block4: {
            block2: {
                String takingScheme;
                block3: {
                    medicament.entryType = EntryType.FIXED_MEDICATION;
                    takingScheme = this.mediplanService.getPFieldValue(medicament, "TkgSch");
                    if (!StringUtils.isNotBlank((CharSequence)takingScheme)) break block2;
                    if (!"Prd".equals(takingScheme)) break block3;
                    medicament.entryType = EntryType.SYMPTOMATIC_MEDICATION;
                    break block4;
                }
                if (!"Ond".equals(takingScheme)) break block4;
                medicament.entryType = EntryType.RESERVE_MEDICATION;
                break block4;
            }
            if (medicament.Pos != null && !medicament.Pos.isEmpty()) {
                for (Posology pos : medicament.Pos) {
                    if (pos.InRes != 1) continue;
                    medicament.entryType = EntryType.RESERVE_MEDICATION;
                }
            }
        }
        IPrescription prescription = (IPrescription)new IPrescriptionBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), (IArticle)medicament.artikelstammItem, patient, medicament.dosis).build();
        this.getLocalDateTime(medicament.dateFrom).ifPresent(ldt -> prescription.setDateFrom(ldt));
        this.getLocalDateTime(medicament.dateTo).ifPresent(ldt -> prescription.setDateTo(ldt));
        prescription.setRemark(medicament.AppInstr);
        prescription.setEntryType(medicament.entryType);
        prescription.setDisposalComment(medicament.TkgRsn);
        CoreModelServiceHolder.get().save((Identifiable)prescription);
        return prescription;
    }

    private Optional<LocalDateTime> getLocalDateTime(String dateString) {
        if (dateString != null && !dateString.isEmpty()) {
            return Optional.of(new TimeTool(dateString).toLocalDateTime());
        }
        return Optional.empty();
    }
}

