/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.inbox;

import at.medevit.elexis.emediplan.StartupHandler;
import at.medevit.elexis.emediplan.inbox.EMediplanLabelProvider;
import at.medevit.elexis.emediplan.inbox.EMediplanViewerFilter;
import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.ui.part.provider.IInboxElementUiProvider;
import ch.elexis.core.model.IBlob;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wb.swt.ResourceManager;

public class EMediplanUiProvider
implements IInboxElementUiProvider {
    private EMediplanLabelProvider labelProvider = new EMediplanLabelProvider();
    private EMediplanViewerFilter filter = new EMediplanViewerFilter();

    public ImageDescriptor getFilterImage(ViewerFilter filter) {
        return ResourceManager.getPluginImageDescriptor((String)"at.medevit.elexis.emediplan.ui", (String)"rsc/logo.png");
    }

    public List<ViewerFilter> getFilters() {
        return Collections.singletonList(this.filter);
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IColorProvider getColorProvider() {
        return null;
    }

    public IToolTipProvider getToolTipProvider() {
        return null;
    }

    public LocalDate getObjectDate(IInboxElement element) {
        IBlob document = (IBlob)element.getObject();
        return new TimeTool(document.getLastupdate().longValue()).toLocalDate();
    }

    public boolean isProviderFor(IInboxElement element) {
        Object obj = element.getObject();
        return obj instanceof IBlob && ((IBlob)obj).getId().startsWith("Med_");
    }

    public void doubleClicked(IInboxElement element) {
        Object obj = element.getObject();
        if (this.isProviderFor(element)) {
            IBlob document = (IBlob)obj;
            StartupHandler.openEMediplanImportDialog(document.getStringContent(), element.getPatient().getId());
        }
    }
}

