/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.ui.handler;

import at.medevit.elexis.emediplan.core.EMediplanService;
import at.medevit.elexis.emediplan.ui.handler.SaveEMediplanUtil;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.medication.handlers.PrintTakingsListHandler;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class CreateAndOpenHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IPrescription> prescriptions;
        IPatient patient = ContextServiceHolder.get().getActivePatient().orElse(null);
        if (patient == null) {
            return null;
        }
        IMandator mandant = ContextServiceHolder.get().getActiveMandator().orElse(null);
        if (mandant == null) {
            return null;
        }
        String medicationType = event.getParameter("ch.elexis.core.ui.medication.commandParameter.medication");
        if (medicationType == null || medicationType.isEmpty()) {
            medicationType = "all";
        }
        if ((prescriptions = this.getPrescriptions(patient, medicationType, event)) != null && !prescriptions.isEmpty()) {
            prescriptions = this.sortPrescriptions(prescriptions, event);
            BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
            ServiceReference eMediplanServiceRef = bundleContext.getServiceReference(EMediplanService.class);
            if (eMediplanServiceRef != null) {
                EMediplanService eMediplanService = (EMediplanService)bundleContext.getService(eMediplanServiceRef);
                ByteArrayOutputStream pdfOutput = new ByteArrayOutputStream();
                eMediplanService.exportEMediplanPdf(mandant, patient, prescriptions, (OutputStream)pdfOutput);
                IDocument letter = SaveEMediplanUtil.saveEMediplan(patient, mandant, pdfOutput.toByteArray());
                try {
                    Program.launch((String)SaveEMediplanUtil.writeTempPdf(pdfOutput));
                    ContextServiceHolder.get().postEvent("info/elexis/emediplan/ui/create", (Object)letter);
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Das Rezept konnte nicht angezeigt werden.");
                }
                bundleContext.ungetService(eMediplanServiceRef);
            } else {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("No EMediplanService available");
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)"Kein eMediplan Service gefunden.");
            }
        }
        return null;
    }

    private List<IPrescription> sortPrescriptions(List<IPrescription> prescriptions, ExecutionEvent event) {
        PrintTakingsListHandler.SorterAdapter sorter = new PrintTakingsListHandler.SorterAdapter(event);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof MedicationView) {
            return sorter.getSorted(prescriptions);
        }
        return prescriptions;
    }

    private List<IPrescription> getPrescriptions(IPatient patient, String medicationType, ExecutionEvent event) {
        if ("selection".equals(medicationType)) {
            ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
            if (selection != null && !selection.isEmpty()) {
                ArrayList<IPrescription> ret = new ArrayList<IPrescription>();
                IStructuredSelection strucSelection = (IStructuredSelection)selection;
                if (strucSelection.getFirstElement() instanceof MedicationTableViewerItem) {
                    List mtvItems = strucSelection.toList();
                    for (MedicationTableViewerItem mtvItem : mtvItems) {
                        IPrescription p = mtvItem.getPrescription();
                        if (p == null) continue;
                        ret.add(p);
                    }
                } else if (strucSelection.getFirstElement() instanceof IPrescription) {
                    ret.addAll(strucSelection.toList());
                }
                return ret;
            }
        } else {
            if ("all".equals(medicationType)) {
                ArrayList<IPrescription> ret = new ArrayList<IPrescription>();
                ret.addAll(patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION)));
                return ret;
            }
            if ("fix".equals(medicationType)) {
                return patient.getMedication(Collections.singletonList(EntryType.FIXED_MEDICATION));
            }
            if ("reserve".equals(medicationType)) {
                return patient.getMedication(Collections.singletonList(EntryType.RESERVE_MEDICATION));
            }
            if ("symptomatic".equals(medicationType)) {
                return patient.getMedication(Collections.singletonList(EntryType.SYMPTOMATIC_MEDICATION));
            }
        }
        return Collections.emptyList();
    }
}

