/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.core.model.chmed16a;

import at.medevit.elexis.emediplan.core.model.chmed16a.Medicament;
import at.medevit.elexis.emediplan.core.model.chmed16a.Patient;
import at.medevit.elexis.emediplan.core.model.chmed16a.PrivateField;
import at.medevit.elexis.emediplan.core.model.chmed16a.Recommendation;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IXid;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

public class Medication {
    public Patient Patient;
    public List<Medicament> Medicaments;
    public List<Recommendation> Recoms;
    public List<PrivateField> PFields;
    public String PSchema;
    public int MedType;
    public String Id;
    public String Auth;
    public String Zsr;
    public String Dt;
    public String Rmk;
    public String ValBy;
    public String ValDt;
    public transient String chunk;

    public static Medication fromPrescriptions(@NonNull IMandator author, @NonNull IPatient patient, @NonNull List<IPrescription> prescriptions, boolean addDesc) {
        Medication ret = new Medication();
        ret.MedType = 1;
        ret.Id = UUID.randomUUID().toString();
        ret.Dt = LocalDateTime.now().toString();
        IXid gln = author.getXid("www.xid.ch/id/ean");
        if (gln != null) {
            if (gln.getDomainId() != null && !gln.getDomainId().isEmpty()) {
                ret.Auth = gln.getDomainId();
            }
        } else {
            ret.Auth = author.getLabel();
        }
        if (!prescriptions.isEmpty()) {
            ret.Patient = at.medevit.elexis.emediplan.core.model.chmed16a.Patient.fromPatient(patient);
            ret.Medicaments = Medicament.fromPrescriptions(prescriptions, addDesc);
        }
        return ret;
    }

    public String getNamedBlobId() {
        if (this.Id == null) {
            throw new IllegalStateException("id cannot be null");
        }
        return "Med_" + this.Id;
    }
}

