/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.core.model.print;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.data.Anwender;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.format.DateTimeFormatter;

@XmlRootElement(name="medicament")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Medicament {
    public String name;
    public String dosageText;
    public String dosageMorning;
    public String dosageNoon;
    public String dosageEvening;
    public String dosageNight;
    public String unit;
    public String type;
    public String startDate;
    public String endDate;
    public String remarks;
    public String reason;
    public String prescriptor;

    public static Medicament fromPrescription(IPrescription prescription) {
        boolean isFreetext;
        Medicament ret = new Medicament();
        ret.name = prescription.getArticle().getLabel();
        String[] signature = MedicationServiceHolder.get().getSignatureAsStringArray(prescription.getDosageInstruction());
        boolean bl = isFreetext = !signature[0].isEmpty() && signature[1].isEmpty() && signature[2].isEmpty() && signature[3].isEmpty();
        if (isFreetext) {
            ret.dosageText = signature[0];
        } else {
            ret.dosageMorning = signature[0];
            ret.dosageNoon = signature[1];
            ret.dosageEvening = signature[2];
            ret.dosageNight = signature[3];
            ret.type = "t\u00e4glich";
        }
        ret.startDate = prescription.getDateFrom() != null ? DateTimeFormatter.ofPattern("dd.MM.yyyy").format(prescription.getDateFrom()) : "";
        ret.endDate = prescription.getDateTo() != null ? DateTimeFormatter.ofPattern("dd.MM.yyyy").format(prescription.getDateTo()) : "";
        ret.remarks = prescription.getRemark();
        ret.reason = prescription.getDisposalComment();
        String prescriptorId = prescription.getPrescriptor() != null ? prescription.getPrescriptor().getId() : "";
        ret.prescriptor = Medicament.getPrescriptorLabel(prescriptorId);
        return ret;
    }

    private static String getPrescriptorLabel(String prescriptorId) {
        Anwender prescriptor;
        if (prescriptorId != null && !prescriptorId.isEmpty() && (prescriptor = Anwender.load((String)prescriptorId)) != null && prescriptor.exists()) {
            String title = prescriptor.get("Titel");
            String firstname = prescriptor.get("Bezeichnung2");
            String lastname = prescriptor.get("Bezeichnung1");
            return (String)(title != null && !title.isEmpty() ? title + " " : "") + (String)(firstname != null && !firstname.isEmpty() ? firstname + " " : "") + (String)(lastname != null && !lastname.isEmpty() ? lastname + " " : "");
        }
        return null;
    }
}

