/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.emediplan.core.model.chmed16a;

import at.medevit.elexis.emediplan.core.model.chmed16a.MedicalData;
import at.medevit.elexis.emediplan.core.model.chmed16a.PatientId;
import at.medevit.elexis.emediplan.core.model.chmed16a.PrivateField;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.Gender;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.util.List;

public class Patient {
    public String FName;
    public String LName;
    public String BDt;
    public Integer Gender;
    public String Street;
    public String Zip;
    public String City;
    public String Lng;
    public String Phone;
    public String Rcv;
    public List<PatientId> Ids;
    public List<MedicalData> Med;
    public List<PrivateField> PFields;
    public transient String patientId;
    public transient String patientLabel;

    public static Patient fromPatient(IPatient elexisPatient) {
        Patient ret = new Patient();
        ret.FName = elexisPatient.getFirstName();
        ret.LName = elexisPatient.getLastName();
        LocalDateTime dob = elexisPatient.getDateOfBirth();
        if (dob != null) {
            ret.BDt = new TimeTool(dob).toString(6);
        }
        Gender gender = elexisPatient.getGender();
        switch (gender) {
            case FEMALE: {
                ret.Gender = 2;
                break;
            }
            case MALE: {
                ret.Gender = 1;
                break;
            }
            default: {
                ret.Gender = null;
            }
        }
        ret.Street = elexisPatient.getStreet();
        ret.Zip = elexisPatient.getZip();
        ret.City = elexisPatient.getCity();
        ret.Lng = "de";
        ret.Phone = elexisPatient.getPhone1();
        return ret;
    }
}

