/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.inbox;

import at.medevit.elexis.ehc.ui.inbox.EhcDocumentLabelProvider;
import at.medevit.elexis.ehc.ui.model.EhcDocument;
import at.medevit.elexis.ehc.ui.views.EHealthConnectorView;
import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.ui.part.provider.IInboxElementUiProvider;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboxElementUiProvider
implements IInboxElementUiProvider {
    private static Logger logger = LoggerFactory.getLogger(InboxElementUiProvider.class);
    private EhcDocumentLabelProvider labelProvider = new EhcDocumentLabelProvider();

    public ImageDescriptor getFilterImage(ViewerFilter filter) {
        return null;
    }

    public List<ViewerFilter> getFilters() {
        return Collections.emptyList();
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IColorProvider getColorProvider() {
        return null;
    }

    public IToolTipProvider getToolTipProvider() {
        return null;
    }

    public LocalDate getObjectDate(IInboxElement element) {
        EhcDocument document = (EhcDocument)((Object)element.getObject());
        return new TimeTool(document.get("timestamp")).toLocalDate();
    }

    public boolean isProviderFor(IInboxElement element) {
        Object obj = element.getObject();
        return obj instanceof EhcDocument;
    }

    public void doubleClicked(IInboxElement element) {
        Object obj = element.getObject();
        if (obj instanceof EhcDocument) {
            EhcDocument document = (EhcDocument)((Object)obj);
            try {
                EHealthConnectorView view = (EHealthConnectorView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("at.medevit.elexis.eHealthConnectorView");
                view.displayReport(document.getLocation().openStream(), null);
            }
            catch (IOException | PartInitException e) {
                logger.error("Could not open ehc document", e);
            }
        }
    }
}

