/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.vacdoc.wizard;

import at.medevit.elexis.ehc.ui.preference.PreferencePage;
import at.medevit.elexis.ehc.ui.vacdoc.composite.VaccinationSelectionComposite;
import at.medevit.elexis.ehc.ui.vacdoc.service.OutboxElementServiceHolder;
import at.medevit.elexis.ehc.ui.vacdoc.service.VacdocServiceComponent;
import at.medevit.elexis.ehc.ui.vacdoc.wizard.ExportVaccinationsWizard;
import at.medevit.elexis.ehc.vacdoc.service.VacdocService;
import at.medevit.elexis.impfplan.model.po.Vaccination;
import at.medevit.elexis.outbox.model.OutboxElementType;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;

public class ExportVaccinationsWizardPage1
extends WizardPage {
    private Patient selectedPatient;
    private final ExportVaccinationsWizard.ExportType exportType;
    private VaccinationSelectionComposite composite;

    protected ExportVaccinationsWizardPage1(String pageName, ExportVaccinationsWizard.ExportType exportType) {
        super(pageName);
        this.setTitle(pageName);
        this.exportType = exportType;
    }

    public void createControl(Composite parent) {
        this.composite = new VaccinationSelectionComposite(parent, 0);
        this.composite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportVaccinationsWizardPage1.this.getWizard().getContainer().updateButtons();
            }
        });
        Composite c = new Composite((Composite)this.composite, 0x4000000);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(768));
        this.setControl((Control)this.composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setErrorMessage(null);
            Query qbe = new Query(Vaccination.class);
            this.selectedPatient = ElexisEventDispatcher.getSelectedPatient();
            if (this.selectedPatient != null) {
                qbe.add("Patient_ID", "=", this.selectedPatient.getId());
                qbe.orderBy(true, new String[]{"dateOfAdministration", "lastupdate"});
                List vaccinations = qbe.execute();
                this.composite.setInput(vaccinations);
                this.composite.setSelection(new StructuredSelection(vaccinations), true);
                String ahvNr = this.selectedPatient.getXid("www.ahv.ch/xid");
                if (ahvNr == null || ahvNr.isEmpty()) {
                    this.setErrorMessage("Patient hat keine AHV Nummer.");
                }
            } else {
                this.setErrorMessage("Es ist kein Patient ausgew\u00e4hlt.");
            }
        }
    }

    public boolean isPageComplete() {
        IStructuredSelection contentSelection = this.composite.getSelection();
        String ahvNr = this.selectedPatient.getXid("www.ahv.ch/xid");
        return !contentSelection.isEmpty() && ahvNr != null && !ahvNr.isEmpty();
    }

    private List<Vaccination> getSelectedVaccinations() {
        IStructuredSelection contentSelection = this.composite.getSelection();
        if (!contentSelection.isEmpty()) {
            return contentSelection.toList();
        }
        return Collections.emptyList();
    }

    public boolean finish() {
        String outputFile = "";
        try {
            Patient elexisPatient = ElexisEventDispatcher.getSelectedPatient();
            Mandant elexisMandant = ElexisEventDispatcher.getSelectedMandator();
            String outputDir = ConfigServiceHolder.getUser((String)PreferencePage.EHC_OUTPUTDIR, (String)PreferencePage.getDefaultOutputDir());
            VacdocService service = VacdocServiceComponent.getService();
            Bundle document = service.getVacdocDocument(elexisPatient, elexisMandant);
            service.addVaccinations(document, this.getSelectedVaccinations());
            switch (this.exportType) {
                case FHIR: {
                    outputFile = this.writeAsFHIR(elexisPatient, outputDir, service, document);
                    this.createOutboxElement(elexisPatient, elexisMandant, outputFile);
                    break;
                }
                case XDM: {
                    outputFile = this.writeAsXDM(elexisPatient, outputDir, service, document);
                    break;
                }
            }
        }
        catch (Exception e) {
            ExportVaccinationsWizard.logger.error("Export failed.", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Es ist ein Fehler beim Impfungen exportiern nach [" + outputFile + "] aufgetreten."));
            return false;
        }
        return true;
    }

    private void createOutboxElement(Patient patient, Mandant mandant, String outputFile) {
        OutboxElementServiceHolder.getService().createOutboxElement((IPatient)CoreModelServiceHolder.get().load(patient.getId(), IPatient.class).orElse(null), (IMandator)CoreModelServiceHolder.get().load(mandant.getId(), IMandator.class).orElse(null), OutboxElementType.FILE.getPrefix() + outputFile);
    }

    private String writeAsXDM(Patient elexisPatient, String outputDir, VacdocService service, Bundle document) throws Exception, FileNotFoundException, IOException {
        InputStream xdmDocumentStream = service.getXdmAsStream(document);
        String outputFile = outputDir + File.separator + this.getVaccinationsFileName(elexisPatient) + ".xdm";
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        IOUtils.copy((InputStream)xdmDocumentStream, (OutputStream)outputStream);
        xdmDocumentStream.close();
        outputStream.close();
        return outputFile;
    }

    private String writeAsFHIR(Patient elexisPatient, String outputDir, VacdocService service, Bundle bundle) throws Exception, FileNotFoundException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String fhirJson = ModelUtil.getFhirJson((IBaseResource)bundle);
        out.write(fhirJson.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        String outputFile = outputDir + File.separator + this.getVaccinationsFileName(elexisPatient) + "_" + System.currentTimeMillis() + ".json";
        Throwable throwable = null;
        Object var10_11 = null;
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            IOUtils.copy((InputStream)in, (OutputStream)outputStream);
            ((InputStream)in).close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return outputFile;
    }

    private String getVaccinationsFileName(Patient patient) {
        return "vacc_" + patient.getPatCode();
    }
}

