/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.core;

import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.Xid;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.StringType;
import org.projecthusky.common.basetypes.AddressBaseType;
import org.projecthusky.common.basetypes.IdentificatorBaseType;
import org.projecthusky.common.basetypes.NameBaseType;
import org.projecthusky.common.basetypes.OrganizationBaseType;
import org.projecthusky.common.enums.AdministrativeGender;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.TelecomAddressUse;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Telecom;
import org.slf4j.LoggerFactory;

public class EhcCoreMapper {
    private static final Pattern lastIntPattern = Pattern.compile("[^0-9]+([0-9]+)[a-z]?$");

    public static Name getEhcName(String name) {
        NameBaseType baseType = new NameBaseType();
        String[] parts = name.split(" ");
        if (parts.length == 1) {
            baseType.setFamily(parts[0]);
        } else if (parts.length == 2) {
            baseType.setGiven(parts[0]);
            baseType.setFamily(parts[1]);
        } else if (parts.length >= 3) {
            baseType.setPrefix(parts[0]);
            baseType.setGiven(parts[1]);
            baseType.setFamily(parts[2]);
        }
        return new Name(baseType);
    }

    public static org.projecthusky.common.model.Patient getEhcPatient(Patient elexisPatient) {
        String socialSecurityNumber;
        Anschrift elexisAddress;
        org.projecthusky.common.model.Patient ret = new org.projecthusky.common.model.Patient(EhcCoreMapper.getEhcPersonName((Person)elexisPatient), EhcCoreMapper.getEhcGenderCode((Person)elexisPatient), (Calendar)new TimeTool(elexisPatient.getGeburtsdatum()));
        System.out.println();
        String value = elexisPatient.get("Telefon1");
        if (value != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            ret.setTelecoms(Collections.singletonList(new Telecom(Telecom.builder().withValue(value).withUsage(TelecomAddressUse.PRIVATE).build())));
        }
        if ((value = elexisPatient.get("NatelNr")) != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            ret.setTelecoms(Collections.singletonList(new Telecom(Telecom.builder().withValue(value).withUsage(TelecomAddressUse.MOBILE).build())));
        }
        if ((elexisAddress = elexisPatient.getAnschrift()) != null) {
            ret.addAddress(EhcCoreMapper.getEhcAddress(elexisAddress));
        }
        if ((socialSecurityNumber = elexisPatient.getXid("www.ahv.ch/xid")) != null) {
            socialSecurityNumber = socialSecurityNumber.trim();
            if ((socialSecurityNumber = socialSecurityNumber.replaceAll("\\.", "")).length() == 11) {
                ret.addId(new Identificator(CodeSystems.SWISS_SSN_DEPRECATED.getCodeSystemId(), socialSecurityNumber));
            } else if (socialSecurityNumber.length() == 13) {
                ret.addId(new Identificator(CodeSystems.SWISS_SSN.getCodeSystemId(), socialSecurityNumber));
            } else {
                LoggerFactory.getLogger(EhcCoreMapper.class).warn("Ignoring SSN [" + socialSecurityNumber + "] length " + socialSecurityNumber.length() + " not vaild.");
            }
        }
        return ret;
    }

    public static Address getEhcAddress(Anschrift elexisAddress) {
        String elexisStreet = elexisAddress.getStrasse();
        String houseNumber = "";
        Matcher matcher = lastIntPattern.matcher(elexisStreet);
        if (matcher.find()) {
            houseNumber = matcher.group(1);
            elexisStreet = elexisStreet.substring(0, matcher.start(1));
        }
        Address ehcAddress = new Address(Address.builder().withStreetAddressLine1(elexisAddress.getStrasse()).withStreetName(elexisStreet.trim()).withBuildingNumber(houseNumber).withPostalCode(elexisAddress.getPlz()).withCity(elexisAddress.getOrt()).build());
        return ehcAddress;
    }

    public static Author getEhcAuthor(Mandant elexisMandant) {
        Anschrift elexisAddress;
        String value;
        String gln = elexisMandant.getXid("www.xid.ch/id/ean");
        Author ret = new Author(EhcCoreMapper.getEhcPersonName((Person)elexisMandant), gln);
        if (gln != null) {
            ret.addId(new Identificator("1.3.88", gln));
        }
        if ((value = elexisMandant.get("Telefon1")) != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            ret.setTelecoms(Collections.singletonList(new Telecom(Telecom.builder().withValue(value).withUsage(TelecomAddressUse.PRIVATE).build())));
        }
        if ((value = elexisMandant.get("NatelNr")) != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            ret.setTelecoms(Collections.singletonList(new Telecom(Telecom.builder().withValue(value).withUsage(TelecomAddressUse.MOBILE).build())));
        }
        if ((elexisAddress = elexisMandant.getAnschrift()) != null) {
            ret.addAddress(EhcCoreMapper.getEhcAddress(elexisAddress));
        }
        return ret;
    }

    public static Organization getEhcOrganization(Mandant elexisMandant) {
        Anschrift elexisAddress;
        String value;
        Rechnungssteller rechnungssteller = elexisMandant.getRechnungssteller();
        String gln = rechnungssteller.getXid("www.xid.ch/id/ean");
        Organization ret = new Organization(OrganizationBaseType.builder().withPrimaryName(NameBaseType.builder().withName(rechnungssteller.getLabel()).build()).build());
        if (StringUtils.isNotBlank((CharSequence)gln)) {
            ret.addIdentificator((IdentificatorBaseType)new Identificator(CodeSystems.GLN.getCodeSystemId(), gln));
        }
        if ((value = elexisMandant.get("Telefon1")) != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            ret.getTelecomList().add(new Telecom(Telecom.builder().withValue(value).withUsage(TelecomAddressUse.PRIVATE).build()));
        }
        if ((value = elexisMandant.get("NatelNr")) != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            ret.getTelecomList().add(new Telecom(Telecom.builder().withValue(value).withUsage(TelecomAddressUse.MOBILE).build()));
        }
        if ((elexisAddress = rechnungssteller.getAnschrift()) != null) {
            ret.addAddress((AddressBaseType)EhcCoreMapper.getEhcAddress(elexisAddress));
        }
        return ret;
    }

    public static Name getEhcPersonName(Person elexisPerson) {
        NameBaseType baseType = new NameBaseType();
        baseType.setFamily(elexisPerson.getName());
        baseType.setGiven(elexisPerson.getVorname());
        baseType.setPrefix(elexisPerson.get("Titel"));
        Name ret = new Name(baseType);
        return ret;
    }

    public static AdministrativeGender getEhcGenderCode(Person elexisPerson) {
        if (elexisPerson.getGeschlecht().equals("w")) {
            return AdministrativeGender.FEMALE;
        }
        if (elexisPerson.getGeschlecht().equals("m")) {
            return AdministrativeGender.MALE;
        }
        return AdministrativeGender.UNDIFFERENTIATED;
    }

    public static Patient getElexisPatient(org.projecthusky.common.model.Patient ehcPatient, boolean create) {
        List ids = ehcPatient.getIds();
        for (Identificator identificator : ids) {
            String idRoot = identificator.getRoot();
            if (!idRoot.equals(CodeSystems.SWISS_SSN_DEPRECATED.getCodeSystemId()) && !idRoot.equals(CodeSystems.SWISS_SSN.getCodeSystemId())) continue;
            IPersistentObject ret = Xid.findObject((String)"www.ahv.ch/xid", (String)identificator.getExtension());
            if (ret instanceof Kontakt && ((Kontakt)ret).istPatient()) {
                return Patient.load((String)ret.getId());
            }
            if (!(ret instanceof Patient)) continue;
            return (Patient)ret;
        }
        Query qpa = new Query(Patient.class);
        Name ehcName = ehcPatient.getName();
        Date ehcBirthdate = ehcPatient.getBirthday();
        String gender = ehcPatient.getAdministrativeGenderCode() == AdministrativeGender.FEMALE ? "w" : "m";
        TimeTool ttBirthdate = new TimeTool();
        if (ehcName.getFamily() != null && !ehcName.getFamily().isEmpty()) {
            qpa.add("Name", "=", ehcName.getFamily());
        }
        if (ehcName.getGiven() != null && !ehcName.getGiven().isEmpty()) {
            qpa.add("Vorname", "=", ehcName.getGiven());
        }
        if (ehcBirthdate != null) {
            ttBirthdate.setTime(ehcBirthdate);
            qpa.add("Geburtsdatum", "=", ttBirthdate.toString(9));
        }
        List existing = qpa.execute();
        Patient ret = null;
        ret = existing.isEmpty() && create ? new Patient(ehcName.getFamily(), ehcName.getGiven(), ttBirthdate.toString(9), gender) : (Patient)existing.get(0);
        return ret;
    }

    public static Patient getElexisPatient(Bundle bundle, boolean create) {
        Iterator<org.hl7.fhir.r4.model.Patient> iterator;
        List<org.hl7.fhir.r4.model.Patient> fhirPatients = bundle.getEntry().stream().filter(e -> e.getResource() != null && e.getResource() instanceof org.hl7.fhir.r4.model.Patient).map(e -> (org.hl7.fhir.r4.model.Patient)e.getResource()).toList();
        if (!fhirPatients.isEmpty() && (iterator = fhirPatients.iterator()).hasNext()) {
            List existing;
            org.hl7.fhir.r4.model.Patient fhirPatient = iterator.next();
            List ids = fhirPatient.getIdentifier();
            for (Identifier identifier : ids) {
                String idRoot = identifier.getSystem();
                if (!idRoot.equals(CodeSystems.SWISS_SSN_DEPRECATED.getCodeSystemId()) && !idRoot.equals(CodeSystems.SWISS_SSN.getCodeSystemId())) continue;
                IPersistentObject ret = Xid.findObject((String)"www.ahv.ch/xid", (String)identifier.getValue());
                if (ret instanceof Kontakt && ((Kontakt)ret).istPatient()) {
                    return Patient.load((String)ret.getId());
                }
                if (!(ret instanceof Patient)) continue;
                return (Patient)ret;
            }
            Query qpa = new Query(Patient.class);
            HumanName fhirName = fhirPatient.getNameFirstRep();
            Date fhirBirthdate = fhirPatient.getBirthDate();
            String gender = fhirPatient.getGender() == Enumerations.AdministrativeGender.FEMALE ? "w" : "m";
            TimeTool ttBirthdate = new TimeTool();
            if (fhirName.getFamily() != null && !fhirName.getFamily().isEmpty()) {
                qpa.add("Name", "=", fhirName.getFamily());
            }
            if (!fhirName.getGiven().isEmpty() && !((StringType)fhirName.getGiven().get(0)).isEmpty()) {
                qpa.add("Vorname", "=", ((StringType)fhirName.getGiven().get(0)).asStringValue());
            }
            if (fhirBirthdate != null) {
                ttBirthdate.setTime(fhirBirthdate);
                qpa.add("Geburtsdatum", "=", ttBirthdate.toString(9));
            }
            if ((existing = qpa.execute()).isEmpty() && create) {
                return new Patient(fhirName.getFamily(), ((StringType)fhirName.getGiven().get(0)).asStringValue(), ttBirthdate.toString(9), gender);
            }
            return (Patient)existing.get(0);
        }
        return null;
    }

    public static void importEhcAddress(Kontakt kontakt, Address address) {
        Anschrift elexisAddress = kontakt.getAnschrift();
        elexisAddress.setOrt(address.getCity());
        elexisAddress.setPlz(address.getPostalCode());
        elexisAddress.setStrasse(address.getStreetName() + " " + address.getBuildingNumber());
        kontakt.setAnschrift(elexisAddress);
    }

    public static void importEhcPhone(Kontakt kontakt, List<Telecom> list) {
        list.forEach(t -> {
            if (StringUtils.isNotBlank((CharSequence)t.getValue())) {
                if (t.getUsage() == TelecomAddressUse.MOBILE) {
                    kontakt.set("Telefon2", t.getValue());
                } else {
                    kontakt.set("Telefon2", t.getValue());
                }
            }
        });
    }
}

