/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.documents.converter;

import ch.elexis.core.documents.DocumentStore;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IDocumentConverter;
import io.swagger.client.ApiException;
import io.swagger.client.api.ConverterControllerApi;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class JodRestDocumentConverter
implements IDocumentConverter {
    @Reference
    private DocumentStore documentStore;
    @Reference
    private IConfigService configService;
    private static final EnumSet<MimeType> SUPPORTED_MIME_TYPES = EnumSet.of(MimeType.doc, new MimeType[]{MimeType.docx, MimeType.xls, MimeType.xlsx, MimeType.odt, MimeType.ods, MimeType.odp, MimeType.rtf, MimeType.txt, MimeType.html, MimeType.csv, MimeType.jpg, MimeType.jpeg, MimeType.png, MimeType.bmp, MimeType.gif, MimeType.tiff, MimeType.svg});

    public Optional<File> convertToPdf(IDocument document) {
        ConverterControllerApi apiInstance = new ConverterControllerApi();
        apiInstance.getApiClient().setBasePath(this.getAppBasePath());
        try {
            String tempFilePath = this.documentStore.saveContentToTempFile(document, JodRestDocumentConverter.getPrefix(document), JodRestDocumentConverter.getExtension(document), true);
            if (tempFilePath != null) {
                File tempFile = new File(tempFilePath);
                File converted = apiInstance.convertToUsingParamUsingPOST(tempFile, "pdf", null);
                tempFile.delete();
                File toDir = new File(tempFile.getParentFile(), "elexispdf_" + System.currentTimeMillis());
                toDir.mkdir();
                File toFile = new File(toDir, JodRestDocumentConverter.getPrefix(document) + ".pdf");
                Path moved = Files.move(converted.toPath(), toFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File ret = moved.toFile();
                toDir.deleteOnExit();
                ret.deleteOnExit();
                return Optional.of(ret);
            }
        }
        catch (ElexisException | ApiException | IOException e) {
            if (e instanceof ApiException) {
                LoggerFactory.getLogger(this.getClass()).error("Error rest api response code [" + ((ApiException)e).getCode() + "]");
            }
            LoggerFactory.getLogger(this.getClass()).error("Error converting document [" + String.valueOf(document) + "]", e);
        }
        return Optional.empty();
    }

    private static String getExtension(IDocument document) {
        String extension = document.getExtension();
        if (extension.indexOf(46) != -1) {
            extension = extension.substring(extension.lastIndexOf(46) + 1);
        }
        return extension;
    }

    private static String getPrefix(IDocument iDocument) {
        int lastDotIndex;
        StringBuilder ret = new StringBuilder();
        ret.append(iDocument.getPatient().getCode()).append("_");
        ret.append(iDocument.getPatient().getLastName()).append(" ");
        ret.append(iDocument.getPatient().getFirstName()).append("_");
        String title = iDocument.getTitle();
        if (iDocument.getExtension() != null && title.endsWith(iDocument.getExtension()) && (lastDotIndex = title.lastIndexOf(46)) != -1) {
            title = title.substring(0, lastDotIndex);
        }
        ret.append(title).append("_");
        ret.append(new SimpleDateFormat("ddMMyyyy_HHmmss").format(iDocument.getLastchanged()));
        return ret.toString().replaceAll("[^a-z\u00fc\u00e4\u00f6A-Z\u00dc\u00c4\u00d60-9 _\\.\\-]", "");
    }

    private String getAppBasePath() {
        return this.configService.get("jodrestconverter/basepath", "https://tools.medelexis.ch/jodconverter/");
    }

    public boolean isAvailable() {
        String basePath = this.getAppBasePath();
        if (StringUtils.isNotEmpty((CharSequence)basePath)) {
            try {
                URI uri = new URI(basePath);
                int port = uri.getPort();
                if (port == -1) {
                    port = basePath.toLowerCase().contains("https") ? 443 : 80;
                }
                return this.isServiceAvailable(uri.getHost(), port, 500);
            }
            catch (URISyntaxException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Invalid basePath URI syntax [" + basePath + "]");
            }
        }
        return false;
    }

    private boolean isServiceAvailable(String serverHost, int serverPort, Integer timeoutms) {
        if (serverHost != null) {
            try {
                InetSocketAddress endpoint = new InetSocketAddress(serverHost, serverPort);
                Socket socket = new Socket();
                socket.connect(endpoint, timeoutms);
                socket.close();
                return true;
            }
            catch (IOException | NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isSupportedFile(IDocument document) {
        if (document == null || StringUtils.isBlank((CharSequence)document.getExtension())) {
            return false;
        }
        String extension = document.getExtension().toLowerCase();
        MimeType mimeType = MimeType.getByExtension((String)extension);
        return SUPPORTED_MIME_TYPES.contains(mimeType);
    }
}

