/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.bluemedication.ui.handler;

import at.medevit.elexis.bluemedication.core.BlueMedicationServiceHolder;
import at.medevit.elexis.bluemedication.core.UploadResult;
import at.medevit.elexis.bluemedication.ui.document.DocumentStoreServiceHolder;
import ch.elexis.core.documents.DocumentStore;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IDocument;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class BlueMedicationDownloadHandler
extends AbstractHandler
implements IHandler {
    private ICommandService commandService;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object object;
        this.commandService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && (object = selection.getFirstElement()) instanceof IDocumentHandle) {
            IDocumentHandle docHandle = (IDocumentHandle)object;
            Optional pending = BlueMedicationServiceHolder.getService().getPendingUploadResult((Object)docHandle);
            if (pending.isPresent()) {
                if ("chmed".equals(((UploadResult)pending.get()).getTyp())) {
                    this.downloadAndImportChmed(docHandle, (UploadResult)pending.get());
                } else if ("pdf".equals(((UploadResult)pending.get()).getTyp())) {
                    this.downloadAndImportPdf(docHandle, (UploadResult)pending.get());
                }
                BlueMedicationServiceHolder.getService().removePendingUploadResult((Object)docHandle);
            }
        }
        return null;
    }

    private void downloadAndImportPdf(IDocumentHandle docHandle, UploadResult uploadResult) {
        Result pdf = BlueMedicationServiceHolder.getService().downloadExtendedPdf(uploadResult);
        if (pdf.isOK()) {
            DocumentStore documentsService = DocumentStoreServiceHolder.getService();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream fis = new FileInputStream(new File((String)pdf.get()));){
                    documentsService.saveDocument((IDocument)docHandle, (InputStream)fis);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ElexisException | IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error saving pdf", e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim speichern des pdf ist ein Fehler aufgetreten. Bitte starten sie den Vorgang neu.");
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error downloading pdf");
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim download des pdf ist ein Fehler aufgetreten. Bitte starten sie den Vorgang neu.");
        }
    }

    private void downloadAndImportChmed(IDocumentHandle docHandle, UploadResult uploadResult) throws ExecutionException {
        Result emediplan = BlueMedicationServiceHolder.getService().downloadEMediplan(uploadResult);
        if (emediplan.isOK()) {
            if (uploadResult.isUploadedMediplan()) {
                if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Import", (String)"M\u00f6chten Sie die aktuelle Medikation mit dem erstellten eMediplan \u00fcberschreiben?")) {
                    Command directImportCommand = this.commandService.getCommand("at.medevit.elexis.emediplan.ui.directImport");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("at.medevit.elexis.emediplan.ui.directImport.parameter.emediplan", (String)emediplan.get());
                    params.put("at.medevit.elexis.emediplan.ui.directImport.parameter.patientid", docHandle.getPatient().getId());
                    params.put("at.medevit.elexis.emediplan.ui.directImport.parameter.stopreason", "BlueMedication EMediplan Import");
                    ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)directImportCommand, params);
                    try {
                        ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                    }
                    catch (NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim import des eMediplan ist ein Fehler aufgetreten. Bitte starten sie den Abgleich neu.");
                    }
                }
            } else {
                Command openImportCommand = this.commandService.getCommand("at.medevit.elexis.emediplan.ui.openImport");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("at.medevit.elexis.emediplan.ui.openImport.parameter.emediplan", (String)emediplan.get());
                params.put("at.medevit.elexis.emediplan.ui.openImport.parameter.patientid", docHandle.getPatient().getId());
                ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)openImportCommand, params);
                try {
                    ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                }
                catch (NotEnabledException | NotHandledException | NotDefinedException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim \u00f6ffnen des eMediplan Import ist ein Fehler aufgetreten. Bitte starten sie den Abgleich neu.");
                }
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error on download", (Object)emediplan.toString());
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim download ist ein Fehler aufgetreten. Bitte starten sie den Abgleich neu.");
        }
    }
}

