/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.composite.ScriptingHelper;
import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import ch.elexis.agenda.util.AppointmentUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.AppointmentHistoryServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.e4.locks.ILockHandler;
import com.equo.chromium.swt.Browser;
import java.time.LocalDateTime;

public class EventResizeFunction
extends AbstractBrowserFunction {
    public EventResizeFunction(Browser browser, String name) {
        super(browser, name);
    }

    public Object function(Object[] arguments) {
        if (arguments.length == 3) {
            final IAppointment termin = CoreModelServiceHolder.get().load((String)arguments[0], IAppointment.class).orElse(null);
            final LocalDateTime startDate = this.getDateTimeArg(arguments[1]);
            final LocalDateTime endDate = this.getDateTimeArg(arguments[2]);
            if (termin == null || AppointmentUtil.isLocked((IAppointment)termin)) {
                new ScriptingHelper(this.getBrowser()).refetchEvents();
                return null;
            }
            if (termin != null) {
                final LocalDateTime oldEndDate = termin.getEndTime();
                AcquireLockBlockingUi.aquireAndRun((Identifiable)termin, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                        EventResizeFunction.this.redraw();
                    }

                    public void lockAcquired() {
                        termin.setStartTime(startDate);
                        termin.setEndTime(endDate);
                        AppointmentHistoryServiceHolder.get().logAppointmentDurationChange(termin, oldEndDate, endDate);
                        CoreModelServiceHolder.get().save((Identifiable)termin);
                        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)termin);
                        EventResizeFunction.this.redraw();
                    }
                });
            } else {
                new ScriptingHelper(this.getBrowser()).refetchEvents();
            }
        } else {
            throw new IllegalArgumentException("Unexpected arguments");
        }
        return null;
    }
}

