/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.composite;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.LoggerFactory;

public interface IAgendaComposite {
    default public Optional<Integer> getConfiguredFontSize() {
        String confFont = ConfigServiceHolder.get().getActiveUserContact("anwender/agendafont", "");
        String[] parts = confFont.split("\\|");
        if (parts.length > 3) {
            try {
                Float floatValue = Float.valueOf(Float.parseFloat(parts[2].trim()));
                return Optional.of(floatValue.intValue());
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(this.getClass()).debug(String.format("Could not parse font size [%s]", parts[2]));
            }
        }
        return Optional.empty();
    }

    default public Optional<String> getConfiguredFontFamily() {
        String confFont = ConfigServiceHolder.get().getActiveUserContact("anwender/agendafont", "");
        String[] parts = confFont.split("\\|");
        if (parts.length > 3) {
            return Optional.of(parts[1]);
        }
        return Optional.empty();
    }

    public String getConfigId();

    public void refetchEvents();

    public void setSelectedDate(LocalDate var1);

    public void setSelectedResources(List<String> var1);

    public Set<String> getSelectedResources();

    public void setSelectedSpanSize(AgendaSpanSize var1);

    public void setScrollToNow(boolean var1);

    public void setShowWeekends(boolean var1);

    public void setFontSize(int var1);

    public void setFontFamily(String var1);

    public static enum AgendaSpanSize {
        MIN5("5 min", "00:05:00"),
        MIN10("10 min", "00:10:00"),
        MIN15("15 min", "00:15:00"),
        MIN20("20 min", "00:20:00"),
        MIN30("30 min", "00:30:00");

        private String label;
        private String calendarString;

        private AgendaSpanSize(String label, String calendarString) {
            this.label = label;
            this.calendarString = calendarString;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getCalendarString() {
            return this.calendarString;
        }
    }
}

