/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import at.medevit.elexis.agenda.ui.function.Messages;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.builder.IAppointmentBuilder;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.AppointmentState;
import ch.elexis.core.types.AppointmentType;
import ch.elexis.dialogs.AppointmentDialog;
import com.equo.chromium.swt.Browser;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DayClickFunction
extends AbstractBrowserFunction {
    private List<String> selectedResources;

    public DayClickFunction(Browser browser, String name) {
        super(browser, name);
    }

    public Object function(Object[] arguments) {
        IAppointment appointment = null;
        if (arguments.length == 1) {
            date = this.getDateTimeArg(arguments[0]);
            if (this.selectedResources != null && !this.selectedResources.isEmpty()) {
                Integer preferredDuration = this.getPreferredDuration(this.selectedResources.get(0), AppointmentServiceHolder.get().getType(AppointmentType.DEFAULT));
                appointment = (IAppointment)new IAppointmentBuilder(CoreModelServiceHolder.get(), this.selectedResources.get(0), date, date.plusMinutes(preferredDuration.intValue()), AppointmentServiceHolder.get().getType(AppointmentType.DEFAULT), AppointmentServiceHolder.get().getState(AppointmentState.DEFAULT)).build();
                this.determineApplyIsAllDay(arguments[0].toString(), date, appointment);
            } else {
                MessageDialog.openInformation((Shell)this.getBrowser().getShell(), (String)Messages.AgendaUI_DayClick_info, (String)Messages.AgendaUI_DayClick_no_resource_selected);
            }
        } else if (arguments.length == 2) {
            date = this.getDateTimeArg(arguments[0]);
            String resource = (String)arguments[1];
            Integer preferredDuration = this.getPreferredDuration(resource, AppointmentServiceHolder.get().getType(AppointmentType.DEFAULT));
            appointment = (IAppointment)new IAppointmentBuilder(CoreModelServiceHolder.get(), resource, date, date.plusMinutes(preferredDuration.intValue()), AppointmentServiceHolder.get().getType(AppointmentType.DEFAULT), AppointmentServiceHolder.get().getState(AppointmentState.DEFAULT)).build();
            this.determineApplyIsAllDay(arguments[0].toString(), date, appointment);
        }
        if (appointment != null) {
            IAppointment editAppointment = appointment;
            ContextServiceHolder.get().getActivePatient().ifPresent(p -> editAppointment.setSubjectOrPatient(p.getId()));
            AppointmentDialog dlg = new AppointmentDialog(editAppointment);
            dlg.setShowAllDay(true);
            dlg.open();
        }
        return null;
    }

    private void determineApplyIsAllDay(String dateTimeString, LocalDateTime date, IAppointment appointment) {
        if (dateTimeString.length() == 10) {
            appointment.setStartTime(date.toLocalDate().atStartOfDay());
            appointment.setEndTime(null);
        }
    }

    private Integer getPreferredDuration(String areaName, String type) {
        Map preferredDurations = AppointmentServiceHolder.get().getPreferredDurations(areaName);
        if (preferredDurations.containsKey(type)) {
            return (Integer)preferredDurations.get(type);
        }
        return 30;
    }

    public void setSelectedResources(List<String> selectedResources) {
        this.selectedResources = selectedResources;
    }
}

