/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.composite.SideBarComposite;
import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import at.medevit.elexis.agenda.ui.rcprap.SingleSourceUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import com.equo.chromium.swt.Browser;
import java.time.LocalDateTime;
import java.util.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.slf4j.LoggerFactory;

public class ContextMenuFunction
extends AbstractBrowserFunction {
    private ISelectionProvider selectionProvider;
    private MPart part;
    private long selectionTimestamp;
    private long lastResourceClick;

    public ContextMenuFunction(MPart part, Browser browser, String name) {
        super(browser, name);
        this.part = part;
    }

    public Object function(Object[] arguments) {
        if (arguments.length == 4) {
            if (this.lastResourceClick > 0L && System.currentTimeMillis() - this.lastResourceClick < 100L) {
                this.lastResourceClick = System.currentTimeMillis();
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Ignoring selection resource click");
                return null;
            }
            this.lastResourceClick = System.currentTimeMillis();
            if (this.selectionTimestamp > 0L && System.currentTimeMillis() - this.selectionTimestamp > 1000L && this.selectionProvider != null) {
                this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Clear selection resource click");
            }
            LocalDateTime date = this.getDateTimeArg(arguments[2]);
            String resource = (String)arguments[3];
            Optional<SideBarComposite> activeSideBar = ContextMenuFunction.getActiveSideBar(this.part);
            activeSideBar.ifPresent(sideBar -> {
                sideBar.setMoveInformation(date, resource);
                if (SingleSourceUtil.isRap()) {
                    Double argX = (Double)arguments[0];
                    Double argY = (Double)arguments[1];
                    this.getBrowser().getMenu().setLocation(argX.intValue() + 100, argY.intValue());
                }
                Display.getDefault().timerExec(100, () -> {
                    if (!this.getBrowser().getMenu().isVisible()) {
                        if (CoreUtil.isMac()) {
                            this.getBrowser().setFocus();
                        }
                        this.getBrowser().getMenu().setVisible(true);
                    }
                });
            });
        } else if (arguments.length == 2) {
            if (this.lastResourceClick > 0L && System.currentTimeMillis() - this.lastResourceClick < 100L) {
                this.lastResourceClick = System.currentTimeMillis();
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Ignoring selection resource click");
                return null;
            }
            this.lastResourceClick = System.currentTimeMillis();
            if (this.selectionTimestamp > 0L && System.currentTimeMillis() - this.selectionTimestamp > 1000L && this.selectionProvider != null) {
                this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Clear selection resource click");
            }
            LocalDateTime date = this.getDateTimeArg(arguments[0]);
            String resource = (String)arguments[1];
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Resource selection [" + resource + "@" + String.valueOf(date) + "]");
            Optional<SideBarComposite> activeSideBar = ContextMenuFunction.getActiveSideBar(this.part);
            activeSideBar.ifPresent(sideBar -> {
                sideBar.setMoveInformation(date, resource);
                Display.getDefault().timerExec(100, () -> {
                    if (!this.getBrowser().getMenu().isVisible()) {
                        if (CoreUtil.isMac()) {
                            this.getBrowser().setFocus();
                        }
                        this.getBrowser().getMenu().setVisible(true);
                    }
                });
            });
        } else if (arguments.length == 1) {
            IAppointment termin = CoreModelServiceHolder.get().load((String)arguments[0], IAppointment.class).orElse(null);
            if (this.selectionProvider != null) {
                StructuredSelection selection = termin != null ? new StructuredSelection((Object)termin) : null;
                this.selectionProvider.setSelection((ISelection)selection);
                this.selectionTimestamp = System.currentTimeMillis();
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Set selection [" + String.valueOf(selection) + "]");
            }
            Display.getDefault().timerExec(100, () -> {
                if (!this.getBrowser().getMenu().isVisible()) {
                    if (CoreUtil.isMac()) {
                        this.getBrowser().setFocus();
                    }
                    this.getBrowser().getMenu().setVisible(true);
                }
            });
        } else if (arguments.length == 0 && this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Clear selection no arguments");
        }
        return null;
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }
}

