/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.composite.ScriptingHelper;
import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import ch.elexis.agenda.composite.AppointmentDetailComposite;
import ch.elexis.agenda.util.AppointmentExtensionHandler;
import ch.elexis.agenda.util.AppointmentUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.agenda.RecurringAppointment;
import ch.elexis.core.services.holder.AppointmentHistoryServiceHolder;
import ch.elexis.core.services.holder.AppointmentServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.e4.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.e4.locks.ILockHandler;
import ch.elexis.dialogs.AppointmentLinkOptionsDialog;
import com.equo.chromium.swt.Browser;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class EventDropFunction
extends AbstractBrowserFunction {
    public EventDropFunction(Browser browser, String name) {
        super(browser, name);
    }

    public Object function(final Object[] arguments) {
        IAppointment termin;
        if (arguments.length >= 3) {
            termin = CoreModelServiceHolder.get().load((String)arguments[0], IAppointment.class).orElse(null);
            if (termin == null || AppointmentUtil.isLocked((IAppointment)termin)) {
                new ScriptingHelper(this.getBrowser()).refetchEvents();
                return null;
            }
        } else {
            throw new IllegalArgumentException("Unexpected arguments");
        }
        AcquireLockBlockingUi.aquireAndRun((Identifiable)termin, (ILockHandler)new ILockHandler(){

            public void lockFailed() {
                EventDropFunction.this.redraw();
            }

            public void lockAcquired() {
                IAppointment current = termin;
                LocalDateTime oldMainTime = current.getStartTime();
                String oldArea = current.getSchedule();
                if (arguments.length >= 5 && Boolean.TRUE.equals(arguments[4])) {
                    IContact k;
                    current = AppointmentServiceHolder.get().clone(termin);
                    AppointmentHistoryServiceHolder.get().logAppointmentCopyFromTo(current, termin.getId(), current.getId());
                    if (termin.isRecurring() && termin.getContact() == null && (k = new RecurringAppointment(termin, CoreModelServiceHolder.get()).getRootAppoinemtent().getContact()) != null) {
                        current.setSubjectOrPatient(k.getId());
                    }
                }
                boolean isMainAppointment = AppointmentExtensionHandler.isMainAppointment((IAppointment)current);
                boolean isAllDay = arguments[1].toString().length() == 10;
                LocalDateTime newMainTime = EventDropFunction.this.getDateTimeArg(arguments[1]);
                String newResource = arguments.length >= 4 && arguments[3] != null ? (String)arguments[3] : current.getSchedule();
                current.setStartTime(newMainTime);
                if (isAllDay) {
                    current.setEndTime(null);
                } else {
                    LocalDateTime endTime = Objects.isNull(arguments[2]) ? newMainTime.plusMinutes(15L) : EventDropFunction.this.getDateTimeArg(arguments[2]);
                    current.setEndTime(endTime);
                }
                if (!newResource.isEmpty()) {
                    current.setSchedule(newResource);
                }
                String newArea = current.getSchedule();
                if (isMainAppointment) {
                    List linkedAppointments = AppointmentExtensionHandler.getLinkedAppointments((IAppointment)current);
                    AppointmentLinkOptionsDialog.MoveActionType moveAction = AppointmentLinkOptionsDialog.showMoveDialog((Shell)Display.getDefault().getActiveShell(), (List)linkedAppointments);
                    switch (moveAction) {
                        case KEEP_MAIN_ONLY: {
                            EventDropFunction.this.lockAndSaveAppointment(current);
                            AppointmentHistoryServiceHolder.get().logAppointmentMove(current, oldMainTime, newMainTime, oldArea, newArea);
                            break;
                        }
                        case MOVE_ALL: {
                            long minutesDifference = Duration.between(oldMainTime, newMainTime).toMinutes();
                            for (IAppointment linkedAppointment : linkedAppointments) {
                                LocalDateTime oldLinkedTime = linkedAppointment.getStartTime();
                                LocalDateTime newLinkedTime = oldLinkedTime.plusMinutes(minutesDifference);
                                linkedAppointment.setStartTime(newLinkedTime);
                                linkedAppointment.setEndTime(newLinkedTime.plusMinutes(linkedAppointment.getDurationMinutes().intValue()));
                                linkedAppointment.setSchedule(linkedAppointment.getSchedule());
                                linkedAppointment.setLastEdit(AppointmentDetailComposite.createTimeStamp());
                                EventDropFunction.this.lockAndSaveAppointment(linkedAppointment);
                                AppointmentHistoryServiceHolder.get().logAppointmentMove(linkedAppointment, oldLinkedTime, newLinkedTime, oldArea, newArea);
                            }
                            EventDropFunction.this.lockAndSaveAppointment(current);
                            AppointmentHistoryServiceHolder.get().logAppointmentMove(current, oldMainTime, newMainTime, oldArea, newArea);
                            break;
                        }
                    }
                } else {
                    EventDropFunction.this.lockAndSaveAppointment(current);
                    AppointmentHistoryServiceHolder.get().logAppointmentMove(current, oldMainTime, newMainTime, oldArea, newArea);
                }
                ContextServiceHolder.get().postEvent("info/elexis/model/reload", IAppointment.class);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)current);
                EventDropFunction.this.redraw();
            }
        });
        return null;
    }

    private void lockAndSaveAppointment(IAppointment appointment) {
        if (LocalLockServiceHolder.get().acquireLock((Object)appointment).isOk()) {
            try {
                appointment.setLastEdit(AppointmentDetailComposite.createTimeStamp());
                CoreModelServiceHolder.get().save((Identifiable)appointment);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)appointment);
            }
            finally {
                LocalLockServiceHolder.get().releaseLock((Object)appointment);
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Failed to acquire lock for appointment: " + appointment.getId());
        }
    }
}

