/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.model.importer;

import at.medevit.ch.artikelstamm.ARTIKELSTAMM;
import at.medevit.ch.artikelstamm.ATCCodeCacheService;
import at.medevit.ch.artikelstamm.ArtikelstammConstants;
import at.medevit.ch.artikelstamm.ArtikelstammHelper;
import at.medevit.ch.artikelstamm.BlackBoxReason;
import at.medevit.ch.artikelstamm.DATASOURCEType;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.SALECDType;
import at.medevit.ch.artikelstamm.model.importer.EntityUtil;
import at.medevit.ch.artikelstamm.model.importer.VersionUtil;
import at.medevit.ch.artikelstamm.model.service.ModelServiceHolder;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.jpa.entities.ArtikelstammItem;
import ch.elexis.core.jpa.model.util.JpaModelUtil;
import ch.elexis.core.rcp.utils.OsgiServiceUtil;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Component(property={"referenceDataId=artikelstamm_v5"})
public class ArtikelstammImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private static Logger log = LoggerFactory.getLogger(ArtikelstammImporter.class);
    private static Map<String, ARTIKELSTAMM.PRODUCTS.PRODUCT> products = new HashMap<String, ARTIKELSTAMM.PRODUCTS.PRODUCT>();
    private static Map<String, ARTIKELSTAMM.LIMITATIONS.LIMITATION> limitations = new HashMap<String, ARTIKELSTAMM.LIMITATIONS.LIMITATION>();
    private static boolean isOddb2xml = false;
    @Reference
    private IElexisEntityManager elexisEntityManager;
    private VersionUtil versionUtil;

    @Activate
    public void activate() {
        this.versionUtil = new VersionUtil(this.elexisEntityManager);
    }

    public boolean isEnabled() {
        try {
            DATASOURCEType datasourceType = this.versionUtil.getDatasourceType();
            return Objects.equals(DATASOURCEType.ODDB_2_XML, datasourceType);
        }
        catch (IllegalArgumentException iae) {
            return true;
        }
    }

    public IStatus performImport(IProgressMonitor monitor, InputStream input, @Nullable Integer newVersion) {
        return this.performImport(monitor, input, true, true, newVersion);
    }

    public IStatus performImport(IProgressMonitor monitor, InputStream input, boolean bPharma, boolean bNonPharma, @Nullable Integer newVersion) {
        EntityUtil entityUtil = new EntityUtil(this.elexisEntityManager);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String bundleVersion = Platform.getBundle((String)"at.medevit.ch.artikelstamm.model").getVersion().toString();
        subMonitor.setTaskName("Einlesen der Aktualisierungsdaten");
        ARTIKELSTAMM importStamm = null;
        try {
            importStamm = ArtikelstammHelper.unmarshallInputStream((InputStream)input);
        }
        catch (JAXBException | SAXException je) {
            String msg = "Fehler beim Einlesen der Import-Datei";
            Status status = new Status(4, "at.medevit.ch.artikelstamm.model.importer", 1, msg, je);
            log.error(msg, je);
            return status;
        }
        subMonitor.worked(10);
        if (newVersion == null) {
            int month = importStamm.getBUILDDATETIME().getMonth();
            int year = importStamm.getBUILDDATETIME().getYear();
            newVersion = Integer.valueOf("" + (year - 2000) + month);
            log.info("[PI] No newVersion provided. Setting to [{}].", (Object)newVersion);
        }
        try {
            DATASOURCEType datasourceType = this.versionUtil.getDatasourceType();
            String message = "Trying to import dataset sourced [" + importStamm.getDATASOURCE().value() + "] while existent database is sourced [" + datasourceType.value() + "]. Please contact support. Exiting.";
            if (importStamm.getDATASOURCE() != datasourceType) {
                log.error(message);
                return new Status(4, "at.medevit.ch.artikelstamm.model.importer", message);
            }
        }
        catch (IllegalArgumentException iae) {
            this.versionUtil.setDataSourceType(importStamm.getDATASOURCE());
        }
        int currentVersion = this.versionUtil.getCurrentVersion();
        log.info("[PI] Aktualisiere{}{} {} vom {} von v{} auf v{}. Importer-Version {}", new Object[]{bPharma ? " Pharma" : "", bNonPharma ? " NonPharma" : "", importStamm.getDATASOURCE(), importStamm.getCREATIONDATETIME().toGregorianCalendar().getTime(), currentVersion, newVersion, bundleVersion});
        subMonitor.setTaskName("Lese Produkte und Limitationen...");
        subMonitor.subTask("Lese Produkt-Details");
        ArtikelstammImporter.populateProducsAndLimitationsMap(importStamm);
        subMonitor.worked(5);
        subMonitor.setTaskName("Setze alle Elemente auf inaktiv...");
        subMonitor.subTask("Setze Elemente auf inaktiv");
        isOddb2xml = importStamm.getDATASOURCE().equals((Object)DATASOURCEType.ODDB_2_XML);
        ArtikelstammImporter.inactivateNonBlackboxedItems();
        subMonitor.worked(5);
        long startTime = System.currentTimeMillis();
        subMonitor.setTaskName("Importiere Artikelstamm " + importStamm.getCREATIONDATETIME().getMonth() + "/" + importStamm.getCREATIONDATETIME().getYear());
        if (bPharma) {
            subMonitor.subTask("Importiere Pharma Products");
            this.updateOrAddProducts(newVersion, importStamm, (IProgressMonitor)subMonitor.split(20));
        }
        subMonitor.subTask("Importiere Artikel");
        this.updateOrAddItems(newVersion, importStamm, bPharma, bNonPharma, (IProgressMonitor)subMonitor.split(50));
        entityUtil.executeUpdate("UPDATE ArtikelstammItem ai SET ai.ldscr=LOWER(ai.dscr)");
        subMonitor.setTaskName("Setze neue Versionsnummer");
        this.versionUtil.setCurrentVersion(newVersion);
        this.versionUtil.setImportSetCreationDate(importStamm.getCREATIONDATETIME().toGregorianCalendar().getTime());
        subMonitor.worked(5);
        long endTime = System.currentTimeMillis();
        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IArtikelstammItem.class);
        log.info("[PI] Artikelstamm import took " + (endTime - startTime) / 1000L + "sec.Used {} {} version {}. . Importer-Version {}. Will rebuild ATCCodeCache", new Object[]{this.versionUtil.getDatasourceType().toString(), this.versionUtil.getImportSetCreationDate(), newVersion, bundleVersion});
        ATCCodeCacheService atcCodeCacheService = OsgiServiceUtil.getService(ATCCodeCacheService.class).orElse(null);
        if (atcCodeCacheService != null) {
            if (!CoreUtil.isTestMode()) {
                atcCodeCacheService.rebuildCache((IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor, (int)1));
            }
        } else {
            log.error("atcCodeService not available, not rebuilding cache!");
        }
        log.info("[PI] Artikelstamm finished rebuilding ATCCodeCache");
        return Status.OK_STATUS;
    }

    private static void inactivateNonBlackboxedItems() {
        log.debug("[BB] Setting all items inactive for isOddb2xml {}...", (Object)isOddb2xml);
        String cmd = "UPDATE ARTIKELSTAMM_CH SET BB='" + Integer.toString(BlackBoxReason.INACTIVE.getNumercialReason()) + "' WHERE BB='" + Integer.toString(BlackBoxReason.NOT_BLACKBOXED.getNumercialReason()) + "'";
        if (isOddb2xml) {
            cmd = cmd + " AND TYPE='P'";
        }
        log.debug("Executing {}", (Object)cmd);
        ModelServiceHolder.get().executeNativeUpdate(cmd);
        log.debug("Done Executing {}", (Object)cmd);
    }

    private static void populateProducsAndLimitationsMap(ARTIKELSTAMM importStamm) {
        products = importStamm.getPRODUCTS().getPRODUCT().stream().collect(Collectors.toMap(p -> p.getPRODNO(), p -> p));
        limitations = importStamm.getLIMITATIONS().getLIMITATION().stream().collect(Collectors.toMap(l -> l.getLIMNAMEBAG(), l -> l));
    }

    private void updateOrAddProducts(int newVersion, ARTIKELSTAMM importStamm, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        EntityUtil entityUtil = new EntityUtil(this.elexisEntityManager);
        List importProductList = importStamm.getPRODUCTS().getPRODUCT();
        subMonitor.beginTask("Importiere " + importProductList.size() + " Produkte", importProductList.size());
        log.debug("[IP] Update or import {} products...", (Object)importProductList.size());
        ArrayList<Object> products = new ArrayList<Object>();
        for (ARTIKELSTAMM.PRODUCTS.PRODUCT product : importProductList) {
            String prodno = product.getPRODNO();
            String trimmedDscr = ArtikelstammImporter.trimDSCR(product.getDSCR(), product.getPRODNO());
            ArtikelstammItem foundProduct = entityUtil.load(prodno, ArtikelstammItem.class);
            if (foundProduct == null) {
                String lang = ConfigServiceHolder.get().getLocal("ablauf/sprache", "d");
                if (lang.equalsIgnoreCase("f") && product.getDSCRF() != null) {
                    trimmedDscr = ArtikelstammImporter.trimDSCR(product.getDSCRF(), product.getPRODNO());
                } else if (lang.equalsIgnoreCase("i") && product.getDSCRI() != null) {
                    trimmedDscr = ArtikelstammImporter.trimDSCR(product.getDSCRI(), product.getPRODNO());
                }
                foundProduct = new ArtikelstammItem();
                foundProduct.setId(product.getPRODNO());
                foundProduct.setCummVersion(Integer.toString(newVersion));
                foundProduct.setType(ArtikelstammConstants.TYPE.X.name());
                foundProduct.setDscr(trimmedDscr);
                foundProduct.setBb("0");
                foundProduct.setAdddscr("");
                log.trace("[IP] Adding product " + foundProduct.getId() + " (" + foundProduct.getDscr() + ")");
            }
            log.trace("[IP] Updating product " + foundProduct.getId() + " (" + trimmedDscr + ")");
            ArtikelstammImporter.setValuesOnArtikelstammProdukt(foundProduct, product, newVersion);
            products.add(foundProduct);
            if (products.size() == 50) {
                entityUtil.save(products);
                products.clear();
            }
            subMonitor.worked(1);
        }
        entityUtil.save(products);
        subMonitor.done();
    }

    private static String trimDSCR(String dscr, String itemId) {
        if (dscr.length() > 100) {
            log.trace("[IP] Delimiting dscr [{}] for product/item [{}] to 100 characters.", (Object)itemId, (Object)dscr);
            dscr = dscr.substring(0, 100);
        }
        return dscr;
    }

    private static void setValuesOnArtikelstammProdukt(ArtikelstammItem ai, ARTIKELSTAMM.PRODUCTS.PRODUCT product, int cummulatedVersion) {
        ai.setBb(Integer.toString(BlackBoxReason.NOT_BLACKBOXED.getNumercialReason()));
        ai.setCummVersion("" + cummulatedVersion);
        ai.setAtc(product.getATC());
        String trimmedDscr = ArtikelstammImporter.trimDSCR(product.getDSCR(), product.getPRODNO());
        String lang = ConfigServiceHolder.get().getLocal("ablauf/sprache", "d");
        if (lang.equalsIgnoreCase("f") && product.getDSCRF() != null) {
            trimmedDscr = ArtikelstammImporter.trimDSCR(product.getDSCRF(), product.getPRODNO());
        } else if (lang.equalsIgnoreCase("i") && product.getDSCRI() != null) {
            trimmedDscr = ArtikelstammImporter.trimDSCR(product.getDSCRI(), product.getPRODNO());
        }
        ai.setDscr(trimmedDscr);
    }

    private void updateOrAddItems(int newVersion, ARTIKELSTAMM importStamm, boolean bPharma, boolean bNonPharma, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        EntityUtil entityUtil = new EntityUtil(this.elexisEntityManager);
        List importItemList = importStamm.getITEMS().getITEM();
        subMonitor.beginTask("Importiere " + importItemList.size() + " items", importItemList.size());
        log.debug("[II] Update or import {} items...", (Object)importItemList.size());
        ArrayList<Object> foundItems = new ArrayList<Object>();
        for (ARTIKELSTAMM.ITEMS.ITEM item : importItemList) {
            ArtikelstammItem foundItem = null;
            List<ArtikelstammItem> result = entityUtil.loadByNamedQuery(Collections.singletonMap("gtin", item.getGTIN()), ArtikelstammItem.class);
            if (result.size() > 0) {
                if (result.size() == 1) {
                    foundItem = result.get(0);
                } else {
                    log.warn("[II] Found multiple items ({}) for GTIN [{}] type {}", new Object[]{result.size(), item.getGTIN(), item.getPHARMATYPE()});
                    for (ArtikelstammItem artikelstammItem : result) {
                        BlackBoxReason bbReason = BlackBoxReason.getByInteger((int)Integer.parseInt(artikelstammItem.getBb()));
                        if (bbReason != BlackBoxReason.INACTIVE && (!isOddb2xml || bbReason != BlackBoxReason.NOT_BLACKBOXED || artikelstammItem.getType() == null || !artikelstammItem.getType().equals("N"))) continue;
                        foundItem = artikelstammItem;
                        log.warn("[II] isOddb2xml {} Selected ID [{}] of {} items to update.", new Object[]{isOddb2xml, foundItem.getId(), result.size()});
                        break;
                    }
                }
            }
            if (bPharma && item.getPHARMATYPE().contentEquals("P") || bNonPharma && item.getPHARMATYPE().contentEquals("N")) {
                boolean keepOverriddenPublicPrice = false;
                boolean keepOverriddenPkgSize = false;
                if (foundItem == null) {
                    String trimmedDscr = ArtikelstammImporter.trimDSCR(item.getDSCR(), item.getGTIN());
                    ArtikelstammConstants.TYPE pharmaType = ArtikelstammConstants.TYPE.X;
                    if (item.getPHARMATYPE() != null) {
                        String ptString = Character.toString(item.getPHARMATYPE().charAt(0));
                        pharmaType = ArtikelstammConstants.TYPE.valueOf((String)ptString.toUpperCase());
                    }
                    BigInteger code = item.getPHAR() != null ? item.getPHAR() : BigInteger.ZERO;
                    String pharmaCode = String.format("%07d", code);
                    foundItem = new ArtikelstammItem();
                    foundItem.setId(ArtikelstammHelper.createUUID((int)newVersion, (String)item.getGTIN(), (BigInteger)code));
                    foundItem.setCummVersion(Integer.toString(newVersion));
                    foundItem.setType(pharmaType.name());
                    foundItem.setGtin(item.getGTIN());
                    foundItem.setPhar(pharmaCode);
                    foundItem.setDscr(trimmedDscr);
                    foundItem.setBb("0");
                    foundItem.setAdddscr("");
                    log.trace("[II] Adding article " + foundItem.getId() + " (" + item.getDSCR() + ")");
                } else {
                    keepOverriddenPublicPrice = ArtikelstammImporter.isUserDefinedPrice(foundItem);
                    keepOverriddenPkgSize = ArtikelstammImporter.isUserDefinedPkgSize(foundItem);
                }
                log.trace("[II] Updating article {} {}  {} {} ({})", new Object[]{item.getPHARMATYPE(), bPharma && item.getPHARMATYPE().contentEquals("P"), bNonPharma && item.getPHARMATYPE().contentEquals("N"), foundItem.getId()});
                ArtikelstammImporter.setValuesOnArtikelstammItem(foundItem, item, newVersion, keepOverriddenPublicPrice, keepOverriddenPkgSize);
            }
            subMonitor.worked(1);
            if (foundItem != null) {
                foundItems.add(foundItem);
            }
            if (foundItems.size() != 100) continue;
            entityUtil.save(foundItems);
            foundItems.clear();
        }
        entityUtil.save(foundItems);
        subMonitor.done();
    }

    private static Double getUserDefinedPriceValue(ArtikelstammItem item) {
        String ppub = item.getPpub();
        if (ppub != null && ppub.startsWith("-")) {
            try {
                return Double.valueOf(ppub);
            }
            catch (NumberFormatException nfe) {
                log.error("Error #getUserDefinedPrice [{}] value is [{}], setting 0", (Object)item.getId(), (Object)ppub);
            }
        }
        return null;
    }

    private static boolean isUserDefinedPrice(ArtikelstammItem item) {
        return ArtikelstammImporter.getUserDefinedPriceValue(item) != null;
    }

    private static boolean isUserDefinedPkgSize(ArtikelstammItem item) {
        return item.getPkg_size() < 0;
    }

    private static void setValuesOnArtikelstammItem(ArtikelstammItem ai, ARTIKELSTAMM.ITEMS.ITEM item, int cummulatedVersion, boolean keepOverriddenPublicPrice, boolean keepOverriddenPkgSize) {
        ARTIKELSTAMM.PRODUCTS.PRODUCT product;
        boolean oddb2xmlOverride;
        ai.setCummVersion("" + cummulatedVersion);
        ai.setPhar(item.getPHAR() != null ? String.format("%07d", item.getPHAR()) : null);
        SALECDType salecd = item.getSALECD();
        boolean bl = oddb2xmlOverride = isOddb2xml && item.getPHARMATYPE().contentEquals("N");
        if (SALECDType.A == salecd || oddb2xmlOverride) {
            ai.setBb(Integer.toString(BlackBoxReason.NOT_BLACKBOXED.getNumercialReason()));
            log.debug("{} Clearing blackboxed as salecd {} is A isSL {} or oddb2xml override {}", new Object[]{item.getGTIN(), salecd, item.isSLENTRY(), oddb2xmlOverride});
        } else {
            log.debug("{} Setting blackboxed as 5 {} != {} SALECDTypt.A  isSL {}", new Object[]{item.getGTIN(), salecd, SALECDType.A, salecd, item.isSLENTRY()});
            ai.setBb(Integer.toString(BlackBoxReason.INACTIVE.getNumercialReason()));
        }
        ai.setGtin(item.getGTIN());
        ai.setType(item.getPHARMATYPE().contentEquals("P") ? "P" : "N");
        ai.setDscr(ArtikelstammImporter.trimDSCR(item.getDSCR(), item.getGTIN()));
        ARTIKELSTAMM.PRODUCTS.PRODUCT pRODUCT = product = item.getPRODNO() != null ? products.get(item.getPRODNO()) : null;
        if (product == null) {
            product = new ARTIKELSTAMM.PRODUCTS.PRODUCT();
        }
        ai.setAtc(product.getATC());
        ai.setProdno(item.getPRODNO());
        String limnamebag = product.getLIMNAMEBAG();
        ARTIKELSTAMM.LIMITATIONS.LIMITATION limitation = null;
        Integer limitationPts = null;
        String limitationDscr = null;
        if (limnamebag != null && (limitation = limitations.get(limnamebag)) != null) {
            limitationPts = limitation.getLIMITATIONPTS();
            limitationDscr = limitation.getDSCR();
        }
        ai.setLimitation(limitation != null);
        ai.setLimitation_pts(limitationPts != null ? limitationPts.toString() : null);
        ai.setLimitation_txt(limitationDscr);
        String compName = null;
        String compGln = null;
        if (item.getCOMP() != null) {
            compName = item.getCOMP().getNAME();
            compGln = item.getCOMP().getGLN();
        }
        ai.setComp_name(compName);
        ai.setComp_gln(compGln);
        ai.setPexf(item.getPEXF() != null ? item.getPEXF().toString() : null);
        if (!keepOverriddenPublicPrice) {
            ai.setPpub(item.getPPUB() != null ? item.getPPUB().toString() : null);
        } else if (item.getPPUB() != null) {
            ArtikelstammImporter.setExtInfo("PPUB_OVERRIDE_STORE", item.getPPUB().toString(), ai);
            log.trace("[II] [{}] Updating ppub override store to [{}]", (Object)ai.getId(), (Object)item.getPPUB());
        }
        ai.setSl_entry(item.isSLENTRY() != null && item.isSLENTRY() != false);
        ai.setDeductible(item.getDEDUCTIBLE() != null ? item.getDEDUCTIBLE().toString() : null);
        ai.setGeneric_type(item.getGENERICTYPE());
        ai.setIkscat(item.getIKSCAT());
        ai.setNarcotic_cas(item.isNARCOTIC() != null && item.isNARCOTIC() != false ? "1" : "0");
        ai.setLppv(item.isLPPV() != null && item.isLPPV() != false);
        if (!keepOverriddenPkgSize) {
            String pkgSize = item.getPKGSIZE() != null ? item.getPKGSIZE().toString() : null;
            try {
                int value = Integer.parseInt(pkgSize != null && pkgSize.length() > 6 ? pkgSize.substring(0, 6).toString() : pkgSize);
                ai.setPkg_size(value);
            }
            catch (NumberFormatException e) {
                log.debug("[II] Non numeric pkg size for [{}] being [{}].", (Object)ai.getId(), (Object)pkgSize);
            }
            if (pkgSize != null && pkgSize.length() > 6) {
                log.debug("[II] Delimited pkg size for [{}] being [{}] to 6 characters.", (Object)ai.getId(), (Object)item.getPKGSIZE().toString());
            }
        } else if (item.getPKGSIZE() != null) {
            ArtikelstammImporter.setExtInfo("PKG_SIZE_OVERRIDE_STORE", item.getPKGSIZE().toString(), ai);
            log.debug("[II] [{}] Updating PKG_SIZE override store to [{}] fld {}", new Object[]{ai.getId(), item.getPKGSIZE(), ai.getPkg_size()});
        }
    }

    public int getCurrentVersion() {
        return this.versionUtil.getCurrentVersion();
    }

    private static void setExtInfo(Object key, Object value, ArtikelstammItem item) {
        Map<Object, Object> extInfo = new Hashtable();
        byte[] bytes = item.getExtInfo();
        if (bytes != null) {
            extInfo = JpaModelUtil.extInfoFromBytes((byte[])bytes);
        }
        if (value == null) {
            extInfo.remove(key);
        } else {
            extInfo.put(key, value);
        }
        item.setExtInfo(JpaModelUtil.extInfoToBytes(extInfo));
    }
}

