/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.model.importer;

import at.medevit.ch.artikelstamm.DATASOURCEType;
import at.medevit.ch.artikelstamm.model.importer.EntityUtil;
import ch.elexis.core.jpa.entities.ArtikelstammItem;
import ch.elexis.core.services.IElexisEntityManager;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;

public class VersionUtil {
    private static DateFormat df = new SimpleDateFormat("ddMMyy HH:mm");
    private static final String VERSION_ENTRY_ID = "VERSION";
    private IElexisEntityManager elexisEntityManager;

    public VersionUtil(IElexisEntityManager elexisEntityManager) {
        this.elexisEntityManager = elexisEntityManager;
    }

    public DATASOURCEType getDatasourceType() {
        ArtikelstammItem versionEntry = new EntityUtil(this.elexisEntityManager).load(VERSION_ENTRY_ID, ArtikelstammItem.class);
        if (versionEntry != null) {
            return DATASOURCEType.fromValue((String)versionEntry.getAdddscr());
        }
        throw new IllegalArgumentException("No Version entry");
    }

    public void setDataSourceType(DATASOURCEType datasource) {
        ArtikelstammItem versionEntry = new EntityUtil(this.elexisEntityManager).load(VERSION_ENTRY_ID, ArtikelstammItem.class);
        if (versionEntry != null) {
            versionEntry.setAdddscr(datasource.value());
            new EntityUtil(this.elexisEntityManager).save(Collections.singletonList(versionEntry));
            return;
        }
        throw new IllegalArgumentException("No Version entry");
    }

    public int getCurrentVersion() {
        ArtikelstammItem versionEntry = new EntityUtil(this.elexisEntityManager).load(VERSION_ENTRY_ID, ArtikelstammItem.class);
        if (versionEntry != null) {
            String ppub = versionEntry.getPpub();
            try {
                return Integer.parseInt(ppub.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void setCurrentVersion(int newVersion) {
        ArtikelstammItem versionEntry = new EntityUtil(this.elexisEntityManager).load(VERSION_ENTRY_ID, ArtikelstammItem.class);
        if (versionEntry != null) {
            versionEntry.setPpub(Integer.toString(newVersion));
            new EntityUtil(this.elexisEntityManager).save(Collections.singletonList(versionEntry));
            return;
        }
        throw new IllegalArgumentException("No Version entry");
    }

    public void setImportSetCreationDate(Date time) {
        ArtikelstammItem versionEntry = new EntityUtil(this.elexisEntityManager).load(VERSION_ENTRY_ID, ArtikelstammItem.class);
        if (versionEntry != null) {
            versionEntry.setDscr(df.format(time.getTime()));
            new EntityUtil(this.elexisEntityManager).save(Collections.singletonList(versionEntry));
            return;
        }
        throw new IllegalArgumentException("No Version entry");
    }

    public Date getImportSetCreationDate() {
        ArtikelstammItem versionEntry = new EntityUtil(this.elexisEntityManager).load(VERSION_ENTRY_ID, ArtikelstammItem.class);
        if (versionEntry != null) {
            String value = versionEntry.getDscr();
            try {
                return df.parse(value);
            }
            catch (ParseException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("No Version entry");
    }
}

