/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.model.service;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.ATCCodeService;
import at.medevit.ch.artikelstamm.ATCCodeCacheService;
import at.medevit.ch.artikelstamm.model.importer.VersionUtil;
import at.medevit.ch.artikelstamm.model.service.ATCCodeCacheUtil;
import at.medevit.ch.artikelstamm.model.service.CoreModelServiceHolder;
import ch.elexis.core.model.IBlobSecondary;
import ch.elexis.core.services.IElexisEntityManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ATCCodeCache
implements ATCCodeCacheService {
    private HashMap<String, Integer> cache;
    private Logger log = LoggerFactory.getLogger(ATCCodeCache.class);
    @Reference
    private ATCCodeService atcCodeService;
    @Reference
    private IElexisEntityManager elexisEntityManager;

    private void initCache() throws IOException, ClassNotFoundException {
        String blobId = this.determineBlobId();
        this.deserializeFromDatabase(blobId);
    }

    private String determineBlobId() {
        return "ATC_ARTSTAMM_CACHE_" + new VersionUtil(this.elexisEntityManager).getCurrentVersion();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deserializeFromDatabase(String id) throws IOException, ClassNotFoundException {
        Optional cacheStorage = CoreModelServiceHolder.get().load(id, IBlobSecondary.class);
        if (cacheStorage.isPresent()) {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                ByteArrayInputStream ba = new ByteArrayInputStream(((IBlobSecondary)cacheStorage.get()).getContent());
                try {
                    try (ObjectInputStream oba = new ObjectInputStream(ba);){
                        this.cache = (HashMap)oba.readObject();
                    }
                    if (ba == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (ba == null) throw throwable;
                    ba.close();
                    throw throwable;
                }
                ba.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        this.rebuildCache((IProgressMonitor)new NullProgressMonitor());
    }

    public int getAvailableArticlesByATCCode(Object element) {
        if (element instanceof ATCCode) {
            Integer value;
            if (this.cache == null) {
                try {
                    this.initCache();
                }
                catch (IOException | ClassNotFoundException e) {
                    this.log.error("Error initializing cache", (Throwable)e);
                    this.cache = null;
                    return -1;
                }
            }
            return (value = this.cache.get(((ATCCode)element).atcCode)) != null ? value : 0;
        }
        return 0;
    }

    public void rebuildCache(IProgressMonitor progressMonitor) {
        this.cache = new ATCCodeCacheUtil().rebuildCache(this.elexisEntityManager, this.atcCodeService, progressMonitor);
    }
}

