/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.cv;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.ATCCodeService;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.elexis.common.service.ATCCodeServiceHolder;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.AtcQueryFilter;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ATCMenuContributionItem
extends ContributionItem {
    private final CommonViewer cov;
    private final String prefAtcLanguage;
    private final CommonViewerContentProvider commonViewerDataProvider;

    public ATCMenuContributionItem(CommonViewer cov, CommonViewerContentProvider commonViewerDataProvider) {
        this.cov = cov;
        this.commonViewerDataProvider = commonViewerDataProvider;
        this.prefAtcLanguage = ConfigServiceHolder.get().get("artikelstamm/atcCodeLanguage", "ger");
    }

    public void fill(Menu menu, int index) {
        StructuredSelection structuredSelection = new StructuredSelection(this.cov.getSelection());
        Object element = structuredSelection.getFirstElement();
        ATCCodeService atcCodeService = ATCCodeServiceHolder.get().get();
        if (atcCodeService == null) {
            return;
        }
        if (element instanceof IArtikelstammItem) {
            IArtikelstammItem ai = (IArtikelstammItem)element;
            List atcHierarchy = atcCodeService.getHierarchyForATCCode(ai.getAtcCode());
            for (ATCCode atcCode : atcHierarchy) {
                MenuItem temp = new MenuItem(menu, 8);
                if (this.prefAtcLanguage.equals("ger")) {
                    temp.setText(atcCode.atcCode + " " + atcCode.name_german);
                } else {
                    temp.setText(atcCode.atcCode + " " + atcCode.name);
                }
                final ATCCode tempC = atcCode;
                temp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ATCMenuContributionItem.this.commonViewerDataProvider.removeAllQueryFilterByType(AtcQueryFilter.class);
                        AtcQueryFilter queryFilter = new AtcQueryFilter();
                        queryFilter.setFilterValue(tempC.atcCode);
                        ATCMenuContributionItem.this.commonViewerDataProvider.addQueryFilter((CommonViewerContentProvider.QueryFilter)queryFilter);
                        ATCMenuContributionItem.this.cov.notify(CommonViewer.Message.update);
                    }
                });
            }
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

