/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.cv;

import ch.elexis.core.model.IContact;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.swt.ResourceManager;

public class BlackboxViewerFilterAction
extends Action {
    private CommonViewerContentProvider commonViewerContentProvider;
    private CommonViewerContentProvider.QueryFilter blackboxOnlyFilter = new BlackboxOnlyQueryFilter();
    private SelectorPanelProvider slp;
    private static final String FILTER_CFG = "BlackboxViewerFilterAction.showInactiveItems";

    public BlackboxViewerFilterAction(CommonViewerContentProvider commonViewerContentProvider, SelectorPanelProvider selectorPanel) {
        this.commonViewerContentProvider = commonViewerContentProvider;
        this.slp = selectorPanel;
        boolean value = false;
        Optional activeUserContact = ContextServiceHolder.get().getActiveUserContact();
        if (activeUserContact.isPresent()) {
            value = ConfigServiceHolder.get().get((IContact)activeUserContact.get(), FILTER_CFG, false);
        }
        this.setChecked(value);
        this.addOrRemoveFilter();
    }

    public ImageDescriptor getImageDescriptor() {
        return ResourceManager.getPluginImageDescriptor((String)"at.medevit.ch.artikelstamm.ui", (String)"/rsc/icons/flag-black.png");
    }

    public int getStyle() {
        return 2;
    }

    public String getToolTipText() {
        return "Inaktive Items anzeigen";
    }

    private void addOrRemoveFilter() {
        if (this.isChecked()) {
            this.commonViewerContentProvider.removeQueryFilter(this.blackboxOnlyFilter);
        } else {
            this.commonViewerContentProvider.addQueryFilter(this.blackboxOnlyFilter);
        }
    }

    public void run() {
        this.addOrRemoveFilter();
        this.slp.getPanel().contentsChanged(null);
        ContextServiceHolder.get().getActiveUserContact().ifPresent(contact -> {
            boolean bl = ConfigServiceHolder.get().set(contact, FILTER_CFG, this.isChecked());
        });
    }

    public String getDescription() {
        return "Inkludiert inaktive Items in die Anzeige (schwarze Fahne)";
    }

    public String getText() {
        return "Inaktive Items";
    }

    private class BlackboxOnlyQueryFilter
    implements CommonViewerContentProvider.QueryFilter {
        private BlackboxOnlyQueryFilter() {
        }

        public void apply(IQuery<?> query) {
            query.and("bb", IQuery.COMPARATOR.EQUALS, (Object)"0");
        }
    }
}

