/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.importer;

import at.medevit.ch.artikelstamm.ArtikelstammHelper;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.elexis.common.service.VersionUtil;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IReferenceDataImporterService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.LoggerFactory;

public class ArtikelstammImporterPage
extends ImporterPage {
    boolean userCanceled = false;
    @Inject
    private IReferenceDataImporterService importerService;

    public ArtikelstammImporterPage() {
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    public List<String> getObjectClass() {
        return Collections.singletonList(IArtikelstammItem.class.getName());
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        final IConfigService.ILocalLock lock = ConfigServiceHolder.get().getLocalLock((Object)"ArtikelstammImporter");
        try {
            if (!lock.tryLock()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"", (String)("Der Importer ist durch einen anderen Benutzer gestartet.\nDie Artikelstammeintr\u00e4ge werden bereits importiert.\n\nStartzeit: " + new TimeTool(lock.getLockCurrentMillis()).toString(1) + "\nGestartet durch: " + lock.getLockMessage() + "\n\nWollen Sie den Importer trotzdem nochmal starten ?"))) {
                            lock.unlock();
                            lock.tryLock();
                            ArtikelstammImporterPage.this.userCanceled = false;
                        } else {
                            ArtikelstammImporterPage.this.userCanceled = true;
                        }
                    }
                });
            }
            if (this.userCanceled) {
                this.userCanceled = false;
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("ArtikelstammImporterPage.doImport " + this.results[0]);
            IReferenceDataImporter refImporter = this.getImporter();
            IStatus status = refImporter.performImport(monitor, (InputStream)new FileInputStream(this.results[0]), null);
            if (!status.isOK()) {
                StatusManager.getManager().handle(status, 2);
            } else {
                ArtikelstammImporterPage.validateLeistungsblockReferences(monitor);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            lock.unlock();
        }
    }

    private IReferenceDataImporter getImporter() {
        return (IReferenceDataImporter)this.importerService.getImporter("artikelstamm_v5").orElseThrow(() -> new IllegalStateException("No ReferenceDataImporter available"));
    }

    public String getTitle() {
        return "Artikelstamm CH Import";
    }

    public String getDescription() {
        return "Importiere Artikelstamm";
    }

    public Composite createPage(Composite parent) {
        Composite versionInfo = new Composite(parent, 0);
        versionInfo.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        versionInfo.setLayout((Layout)new GridLayout(2, false));
        Label lblVersion = new Label(versionInfo, 0);
        lblVersion.setLayoutData((Object)new GridData(16384, 4, false, false));
        lblVersion.setText("Aktuelle Version:");
        Label lblVERSION = new Label(versionInfo, 0);
        lblVERSION.setLayoutData((Object)new GridData(4, 4, true, true));
        int version = VersionUtil.getCurrentVersion();
        StringBuilder sb = new StringBuilder();
        sb.append(" v" + version);
        Date importSetCreationDate = VersionUtil.getImportSetCreationDate();
        if (importSetCreationDate != null) {
            sb.append(" / " + ArtikelstammHelper.monthAndYearWritten.format(VersionUtil.getImportSetCreationDate()));
        }
        lblVERSION.setText(sb.toString());
        ImporterPage.FileBasedImporter ret = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout(2, false));
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static void validateLeistungsblockReferences(IProgressMonitor monitor) {
        HashMap<String, void> nonResolvableArtikelstammItems = new HashMap<String, void>();
        List codeElementBlocks = CoreModelServiceHolder.get().getQuery(ICodeElementBlock.class).execute();
        monitor.beginTask("Checking Artikelstamm-References in Leistungsblock", codeElementBlocks.size());
        for (ICodeElementBlock leistungsblock : codeElementBlocks) {
            void var5_5;
            List list = (List)nonResolvableArtikelstammItems.get(leistungsblock.getId());
            List elements = leistungsblock.getElements();
            List diffToReferences = leistungsblock.getDiffToReferences(elements);
            if (diffToReferences.size() > 0) {
                for (ICodeElement iCodeElement : diffToReferences) {
                    if (!"Artikelstamm".equals(iCodeElement.getCodeSystemName())) continue;
                    if (var5_5 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var5_5.add(iCodeElement.getText() + " [" + iCodeElement.getCode() + "]");
                }
            }
            if (var5_5 != null) {
                nonResolvableArtikelstammItems.put(leistungsblock.getCode(), var5_5);
            }
            monitor.worked(1);
        }
        Set entrySet = nonResolvableArtikelstammItems.entrySet();
        if (!entrySet.isEmpty()) {
            final StringBuilder sb = new StringBuilder();
            sb.append("Die folgenden Artikelstamm-Referenzen in den genannten Leistungsbl\u00f6cken sind nicht mehr aufl\u00f6sbar:\n\n");
            for (Map.Entry entry : entrySet) {
                sb.append((String)entry.getKey() + ":\n");
                List value = (List)entry.getValue();
                for (String string : value) {
                    sb.append("\t" + string + "\n");
                }
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Leistungsblock Artikelstamm-Referenzen", (String)sb.toString());
                }
            });
        }
    }
}

