/*
 * Decompiled with CFR 0.152.
 */
package at.gruber.elexis.mythic22.persistency;

import at.gruber.elexis.mythic22.model.HaematologicalValue;
import at.gruber.elexis.mythic22.model.Mythic22Result;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistencyHandler {
    private static Logger logger = LoggerFactory.getLogger(PersistencyHandler.class);
    private static PersistencyHandler m_instance = null;
    private HashMap<String, String> m_csvMap;
    private String m_csvMapPath = CoreHub.localCfg.get("connectors/mythic22/pathmappingfile", "fail");

    public static PersistencyHandler getInstance() {
        if (m_instance == null) {
            m_instance = new PersistencyHandler();
        }
        return m_instance;
    }

    private PersistencyHandler() {
        this.m_csvMap = new HashMap();
    }

    public boolean persistMythicResult(Mythic22Result mythic22Result) {
        Patient patient = null;
        LinkedList<String> temp = mythic22Result.getDefaultTypeValues().get("PID");
        if (temp != null && !temp.isEmpty()) {
            String patientID = temp.getFirst();
            patient = Patient.loadByPatientID((String)patientID);
            if (patient == null) {
                String message = "Patient " + patientID + " could not be found!";
                Status status = new Status(2, "at.gruber.elexis.mythic22", message);
                StatusManager.getManager().handle((IStatus)status, 2);
                logger.warn(message);
                return false;
            }
            if (!patient.isValid()) {
                String message = "Patient " + patientID + " is not valid!";
                Status status = new Status(2, "at.gruber.elexis.mythic22", message);
                StatusManager.getManager().handle((IStatus)status, 2);
                logger.warn(message);
                return false;
            }
        }
        if (!this.getCSVMappingMap().isEmpty()) {
            for (HaematologicalValue hvalue : mythic22Result.getHaematologicalValues()) {
                if (!this.getCSVMappingMap().containsKey(hvalue.getIdentifier())) continue;
                LabItem labitem = LabItem.load((String)this.getCSVMappingMap().get(hvalue.getIdentifier()));
                if (labitem != null) {
                    new LabResult(patient, new TimeTool(), labitem, hvalue.getValue(), "");
                    continue;
                }
                logger.warn("Could not find laboritem for " + this.getCSVMappingMap().get(hvalue.getIdentifier()));
            }
            return true;
        }
        return false;
    }

    private HashMap<String, String> getCSVMappingMap() {
        if (this.m_csvMap.isEmpty() || !CoreHub.localCfg.get("connectors/mythic22/pathmappingfile", "fail").equals(this.m_csvMapPath)) {
            HashMap<String, String> returnmap = new HashMap<String, String>();
            try {
                String str;
                this.m_csvMapPath = CoreHub.localCfg.get("connectors/mythic22/pathmappingfile", "fail");
                BufferedReader breader = new BufferedReader(new FileReader(this.m_csvMapPath));
                while ((str = breader.readLine()) != null) {
                    str = str.trim();
                    String[] strArray = str.split(";");
                    returnmap.put(strArray[0], strArray[1]);
                }
                breader.close();
            }
            catch (Exception e) {
                String message = "Couldn't read mapping file " + this.m_csvMapPath + ".";
                Status status = new Status(2, "at.gruber.elexis.mythic22", message, (Throwable)e);
                StatusManager.getManager().handle((IStatus)status, 2);
                logger.warn(message);
            }
            this.m_csvMap = returnmap;
        }
        return this.m_csvMap;
    }
}

