/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.internal.Utils;
import com.equo.chromium.swt.internal.Chromium;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefClientSwt;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class SWTEngine {
    public static void initCef(AtomicBoolean closing, AtomicBoolean shuttingDown, Runnable shutdownRunnable) {
        Display.getDefault().asyncExec(() -> {
            Display.getDefault().addListener(21, e -> closing.set(true));
            Display.getDefault().disposeExec(() -> {
                CefApp.getInstance().doMessageLoopWork(-1L);
                if (shuttingDown.get()) {
                    return;
                }
                if (!Utils.isMac() || !closing.get()) {
                    shuttingDown.set(true);
                    if (!Boolean.getBoolean("chromium.disable_close_windowless_before_dispose")) {
                        SWTEngine.closeWindowlessBrowsers();
                    }
                    shutdownRunnable.run();
                }
            });
        });
    }

    private static void closeWindowlessBrowsers() throws UnsatisfiedLinkError {
        Set<CefClient> clients = CefApp.getInstance().getAllClients();
        for (CefClient client : clients) {
            Object[] browsers;
            if (!(client instanceof CefClientSwt) || !((CefClientSwt)client).isOffscreenRendered() || (browsers = client.getAllBrowser()).length <= 0) continue;
            Object[] objectArray = browsers;
            int n = browsers.length;
            int n2 = 0;
            while (n2 < n) {
                Object c = objectArray[n2];
                ChromiumBrowser browserReference = (ChromiumBrowser)((CefBrowser)c).getReference();
                if (browserReference != null) {
                    browserReference.close();
                }
                ++n2;
            }
        }
        SWTEngine.awaitDisposeWindowless();
    }

    private static void awaitDisposeWindowless() {
        long endTime = System.currentTimeMillis() + 3000L;
        boolean continueLoop = true;
        while (continueLoop && System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            CefApp.getInstance().doMessageLoopWork(-1L);
            int clientSize = CefApp.getInstance().getClientsSize();
            if (clientSize != 0 && (clientSize != 1 || ((CefClientSwt)CefApp.getInstance().getAllClients().iterator().next()).isOffscreenRendered())) continue;
            continueLoop = false;
        }
    }

    public static void onContextInitialized(CefApp app) {
        SWTEngine.registerBrowserFunctions(app);
    }

    public static void registerBrowserFunctions(CefApp app) {
        app.registerSchemeHandlerFactory("https", "functions", new CefSchemeHandlerFactory(){

            @Override
            public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
                if (!browser.isPopup()) {
                    if (this.isPartial(request)) {
                        return Chromium.getChromium((CefBrowser)browser).functionsResourceHandler.peek();
                    }
                    return Chromium.getChromium(browser).createFunctionResourceHandler();
                }
                return null;
            }

            protected boolean isPartial(CefRequest request) {
                try {
                    URI url = new URI(request.getURL());
                    return url.getFragment() != null;
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }
        });
    }

    public static boolean isSystemDarkTheme() {
        String swtDark = System.getProperty("chromium.swt_dark");
        if (swtDark == null) {
            boolean isDarkTheme = false;
            try {
                Class<?> systemThemeClass = Class.forName("org.eclipse.swt.widgets.Display");
                Method isSystemDarkThemeMethod = systemThemeClass.getMethod("isSystemDarkTheme", new Class[0]);
                if (isSystemDarkThemeMethod != null) {
                    isDarkTheme = (Boolean)isSystemDarkThemeMethod.invoke(null, new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
            return isDarkTheme;
        }
        return Boolean.parseBoolean(swtDark);
    }

    public static int getSWTVersion() {
        return SWT.getVersion();
    }
}

