/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.utils;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.io.Settings;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.ObjectStreamClass;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreUtil {
    public static final String TEST_MODE = "elexis.test.mode";
    public static final String HOME_MODE = "ch.elexis.home";
    private static Logger logger = LoggerFactory.getLogger(CoreUtil.class);
    private static final OS osType;
    private static final boolean testMode;

    static {
        String osName = System.getProperty("os.name");
        osType = osName.startsWith("Linux") ? OS.LINUX : (osName.startsWith("Mac") || osName.startsWith("Darwin") ? OS.MAC : (osName.startsWith("Windows") ? OS.WINDOWS : OS.UNSPECIFIED));
        testMode = Boolean.valueOf(System.getProperty(TEST_MODE));
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static Path getElexisServerHomeDirectory() {
        String userHomeProp = System.getProperty("user.home");
        File homedir = new File(new File(userHomeProp), "elexis-server");
        if (!homedir.exists()) {
            homedir.mkdir();
        }
        return Paths.get(homedir.toURI());
    }

    public static Optional<DBConnection> getDBConnection(Settings settings) {
        Hashtable<Object, Object> hConn = CoreUtil.getConnectionHashtable(settings);
        if (hConn != null) {
            DBConnection ret = new DBConnection();
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("connectionstring")))) {
                String url = (String)hConn.get("connectionstring");
                ret.connectionString = url = CoreUtil.applyMySqlTimeZoneWorkaround(url);
                DBConnection.getHostName(url).ifPresent(h -> {
                    String string = dBConnection.hostName = h;
                });
                DBConnection.getDatabaseName(url).ifPresent(db -> {
                    String string = dBConnection.databaseName = db;
                });
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("user")))) {
                ret.username = (String)hConn.get("user");
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("pwd")))) {
                ret.password = (String)hConn.get("pwd");
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("driver")))) {
                Optional<DBConnection.DBType> type = DBConnection.DBType.valueOfDriver((String)hConn.get("driver"));
                type.ifPresent(t -> {
                    DBConnection.DBType dBType = dBConnection.rdbmsType = t;
                });
            }
            if (ret.allValuesSet()) {
                return Optional.of(ret);
            }
            StringBuilder sb = new StringBuilder();
            for (Object object : hConn.keySet()) {
                if (!(object instanceof String)) continue;
                sb.append("\n").append(object).append("->").append(hConn.get(object));
            }
            logger.error("Could not get a valid DBConnection from connection setting:" + sb.toString());
        }
        return Optional.empty();
    }

    private static String applyMySqlTimeZoneWorkaround(String dbConnectString) {
        if (dbConnectString.startsWith("jdbc:mysql:") && !dbConnectString.contains("serverTimezone")) {
            dbConnectString = dbConnectString.contains("?") ? String.valueOf(dbConnectString) + "&serverTimezone=Europe/Zurich" : String.valueOf(dbConnectString) + "?serverTimezone=Europe/Zurich";
            logger.info("MySQL dbConnection string correction [{}]", (Object)dbConnectString);
        }
        return dbConnectString;
    }

    @NonNull
    public static Hashtable<Object, Object> getConnectionHashtable(Settings settings) {
        Hashtable<Object, Object> ret = new Hashtable<Object, Object>();
        String cnt = settings.get("verbindung/folded_string", null);
        if (cnt != null) {
            ret = CoreUtil.fold(StringTool.dePrintable((String)cnt));
        }
        return ret;
    }

    private static Hashtable<Object, Object> fold(byte[] flat) {
        return (Hashtable)CoreUtil.foldObject(flat);
    }

    private static Object foldObject(byte[] flat) {
        return CoreUtil.foldObject(flat, null);
    }

    /*
     * Exception decompiling
     */
    private static Object foldObject(byte[] flat, IClassResolver resolver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getWritableUserDir() {
        File userDir;
        String homeProp = System.getProperty(HOME_MODE);
        if (StringUtils.isNotBlank((CharSequence)homeProp)) {
            File baseDir = new File(System.getProperty("user.dir"));
            userDir = new File(baseDir, homeProp);
        } else {
            String userhome = System.getProperty("user.home");
            if (StringUtils.isBlank((CharSequence)userhome)) {
                userhome = System.getProperty("java.io.tmpdir");
            }
            userDir = new File(userhome, "elexis");
        }
        if (!userDir.exists() && !userDir.mkdirs()) {
            logger.error("Panic exit, could not create userdir " + userDir.getAbsolutePath());
            System.exit(-5);
        }
        return userDir;
    }

    public static File getTempDir() {
        File ret = null;
        String temp = System.getProperty("java.io.tmpdir");
        if (!StringTool.isNothing((Object)temp)) {
            ret = new File(temp);
            if (ret.exists() && ret.isDirectory()) {
                return ret;
            }
            if (ret.mkdirs()) {
                return ret;
            }
        }
        return CoreUtil.getWritableUserDir();
    }

    public static String getDefaultDBPath() {
        String base = String.valueOf(System.getProperty("user.home")) + "/elexisdata";
        File f = new File(base);
        if (!f.exists()) {
            f.mkdirs();
        }
        return base;
    }

    public static final OS getOperatingSystemType() {
        return osType;
    }

    public static final boolean isWindows() {
        return osType == OS.WINDOWS;
    }

    public static final boolean isMac() {
        return osType == OS.MAC;
    }

    public static final boolean isLinux() {
        return osType == OS.LINUX;
    }

    public static String getDatabaseProductName() {
        Optional<DataSource> defaultDataSource = OsgiServiceUtil.getService(DataSource.class, "(id=default)");
        if (defaultDataSource.isPresent()) {
            try {
                Connection connection = defaultDataSource.get().getConnection();
                return connection.getMetaData().getDatabaseProductName();
            }
            catch (SQLException e) {
                e.printStackTrace();
                OsgiServiceUtil.ungetService(DataSource.class);
            }
        }
        return "unknown";
    }

    private static interface IClassResolver {
        public Class<?> resolveClass(ObjectStreamClass var1) throws ClassNotFoundException;
    }

    public static enum OS {
        UNSPECIFIED,
        MAC,
        LINUX,
        WINDOWS;

    }
}

