/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import ch.elexis.core.interfaces.ILocalizedEnum;
import java.util.ResourceBundle;

public enum ArticleSubTyp implements ILocalizedEnum
{
    UNKNOWN('U'),
    PHARMA('P'),
    NONPHARMA('N'),
    MAGISTERY('M'),
    MIGEL('L'),
    COMPLEMENTARY('C'),
    COMPLEMENTARY_REDUCED('K'),
    ADDITIVE('A'),
    PRODUCT('X'),
    COVID('V');

    final char type;

    private ArticleSubTyp(char state) {
        this.type = state;
    }

    @Override
    public String getLocaleText() {
        try {
            return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(ArticleSubTyp.class.getSimpleName()) + "_" + this.name());
        }
        catch (Exception e) {
            return this.name();
        }
    }

    public char getTypeChar() {
        return this.type;
    }

    public static ArticleSubTyp byCharSafe(String statusIn) {
        if (statusIn != null && statusIn.length() > 0) {
            ArticleSubTyp[] articleSubTypArray = ArticleSubTyp.values();
            int n = articleSubTypArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArticleSubTyp eaTyp = articleSubTypArray[n2];
                if (eaTyp.type == statusIn.toUpperCase().charAt(0)) {
                    return eaTyp;
                }
                ++n2;
            }
        }
        return UNKNOWN;
    }
}

