/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.status;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ObjectStatus<T>
extends Status {
    private static final String unknownId = "unknown";
    private final T object;

    public ObjectStatus(int severity, String pluginId, int code, String message, Throwable exception, T object) {
        super(severity, pluginId, code, message, exception);
        this.object = object;
    }

    public ObjectStatus(int severity, String pluginId, String message, Throwable exception, T object) {
        super(severity, pluginId, message, exception);
        this.object = object;
    }

    public ObjectStatus(int severity, String pluginId, String message, T object) {
        super(severity, pluginId, message);
        this.object = object;
    }

    public ObjectStatus(IStatus status, T object) {
        super(status.getSeverity(), status.getPlugin(), status.getMessage());
        this.object = object;
    }

    public T getObject() {
        return this.object;
    }

    public T get() {
        return this.object;
    }

    public static <T> ObjectStatus<T> OK_STATUS(T object) {
        return new ObjectStatus<T>(0, unknownId, 0, "ok", null, object);
    }

    public static final <T> ObjectStatus<T> OK_STATUS(String message, T object) {
        return new ObjectStatus<T>(0, unknownId, 0, message, null, object);
    }

    public static <T> ObjectStatus<T> WARNING_STATUS(T object) {
        return new ObjectStatus<T>(2, unknownId, 2, "warn", null, object);
    }

    public static <T> ObjectStatus<T> CANCEL_STATUS(T object) {
        return new ObjectStatus<T>(8, unknownId, 8, "cancel", null, object);
    }

    public static <T> ObjectStatus<T> INFO_STATUS(T object) {
        return new ObjectStatus<T>(1, unknownId, 1, "info", null, object);
    }

    public static <T> ObjectStatus<T> ERROR_STATUS(T object) {
        return new ObjectStatus<T>(4, unknownId, 4, "error", null, object);
    }

    public static <T> ObjectStatus<T> ERROR_STATUS(String message, Throwable exception) {
        return new ObjectStatus<Object>(4, unknownId, 4, message, exception, null);
    }

    public static <T> ObjectStatus<T> ERROR_STATUS(T object, Throwable exception) {
        return new ObjectStatus<T>(4, unknownId, 4, "error", exception, object);
    }

    public static <T> ObjectStatus<T> OK(T object) {
        return new ObjectStatus<T>(0, unknownId, 0, "ok", null, object);
    }

    public static final <T> ObjectStatus<T> OK(String message, T object) {
        return new ObjectStatus<T>(0, unknownId, 0, message, null, object);
    }

    public static <T> ObjectStatus<T> CANCEL(T object) {
        return new ObjectStatus<T>(8, unknownId, 8, "cancel", null, object);
    }

    public static <T> ObjectStatus<T> INFO(T object) {
        return new ObjectStatus<T>(1, unknownId, 1, "info", null, object);
    }

    public static <T> ObjectStatus<T> WARNING(T object) {
        return new ObjectStatus<T>(2, unknownId, 2, "warn", null, object);
    }

    public static <T> ObjectStatus<T> ERROR(T object) {
        return new ObjectStatus<T>(4, unknownId, 4, "error", null, object);
    }

    public static <T> ObjectStatus<T> ERROR_STATUS(String message) {
        return new ObjectStatus<Object>(4, unknownId, 4, message, null, null);
    }

    public static <T> ObjectStatus<T> ERROR(String message) {
        return new ObjectStatus<Object>(4, unknownId, 4, message, null, null);
    }

    public static <T> ObjectStatus<T> ERROR(String message, Throwable exception) {
        return new ObjectStatus<Object>(4, unknownId, 4, message, exception, null);
    }

    public static <T> ObjectStatus<T> ERROR(T object, Throwable exception) {
        return new ObjectStatus<T>(4, unknownId, 4, "error", exception, object);
    }
}

