/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.services.ICodeElementServiceContribution;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ICodeElementService {
    default public String storeToString(ICodeElement element) {
        return String.valueOf(element.getCodeSystemName()) + "|" + element.getCode() + "|" + element.getText();
    }

    default public Optional<ICodeElement> loadFromString(String storeToString, Map<Object, Object> context) {
        String[] parts = this.getStoreToStringParts(storeToString);
        if (parts != null && parts.length > 1) {
            return this.loadFromString(parts[0], parts[1], context);
        }
        return Optional.empty();
    }

    default public String[] getStoreToStringParts(String storeToString) {
        return storeToString.split("\\|");
    }

    public Optional<ICodeElement> loadFromString(String var1, String var2, Map<Object, Object> var3);

    public Optional<IArticle> findArticleByGtin(String var1);

    public List<ICodeElementServiceContribution> getContributionsByTyp(CodeElementTyp var1);

    public Optional<ICodeElementServiceContribution> getContribution(CodeElementTyp var1, String var2);

    public static enum CodeElementTyp {
        SERVICE,
        DIAGNOSE,
        ARTICLE,
        CONFIG,
        USERCONFIG;

    }

    public static enum ContextKeys {
        CONSULTATION,
        COVERAGE,
        MANDATOR,
        LAW,
        DATE,
        TREE_ROOTS;

    }
}

