/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.lock.types;

import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockRequest;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class LockResponse {
    public static final LockResponse OK = new LockResponse(Status.OK, null);
    public static final LockResponse ERROR = new LockResponse(Status.ERROR, null);
    private Status status;
    private LockInfo lockInfo;
    private LockRequest.Type lockRequestType;

    public LockResponse() {
        this.status = Status.OK;
        this.lockInfo = new LockInfo();
    }

    public LockResponse(Status status, LockInfo lockInfo) {
        this(status, lockInfo, null);
    }

    public LockResponse(Status status, LockInfo lockInfo, LockRequest.Type lockRequestType) {
        this.status = status;
        this.lockInfo = lockInfo != null ? lockInfo : new LockInfo();
        this.lockRequestType = lockRequestType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public LockInfo getLockInfo() {
        return this.lockInfo;
    }

    public void setLockInfo(LockInfo lockInfo) {
        this.lockInfo = lockInfo;
    }

    public LockRequest.Type getLockRequestType() {
        return this.lockRequestType;
    }

    public static LockResponse OK(LockInfo lie) {
        return new LockResponse(Status.OK, lie);
    }

    public static LockResponse DENIED(LockInfo lie) {
        return new LockResponse(Status.DENIED, lie);
    }

    public static LockResponse NOINFO(LockInfo lie) {
        return new LockResponse(Status.NOINFO, lie);
    }

    public boolean isOk() {
        return this.getStatus() == Status.OK;
    }

    public static enum Status {
        OK,
        DENIED,
        DENIED_PERMANENT,
        ERROR,
        NOINFO;

    }
}

