/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ac;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.services.IAccessControlService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;

public class ObjectEvaluatableACE
extends EvaluatableACE {
    private final String object;
    private final String storeToString;

    public ObjectEvaluatableACE(String object, Right requestedRight, String storeToString) {
        this.object = object;
        this.storeToString = storeToString;
        this.requestedRightMap[requestedRight.ordinal()] = 1;
        this.requested = (short)(this.requested | 1 << requestedRight.ordinal());
    }

    public ObjectEvaluatableACE(String object, Right requestedRight) {
        this(object, requestedRight, null);
    }

    public ObjectEvaluatableACE(Class<?> clazz, Right requestedRight) {
        this(ObjectEvaluatableACE.getElexisInterfaceName(clazz), requestedRight, null);
    }

    private static String getElexisInterfaceName(Class<?> clazz) {
        if (!clazz.isInterface()) {
            Optional<String> canidate;
            ArrayList<String> canidates = new ArrayList<String>();
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaze = classArray[n2];
                canidates.add(interfaze.getName());
                ++n2;
            }
            if (!canidates.isEmpty() && (canidate = canidates.stream().filter(s -> {
                String lSimplename = s.substring(s.lastIndexOf(46) + 1);
                return Character.isUpperCase(lSimplename.charAt(0)) && Character.isUpperCase(lSimplename.charAt(1));
            }).findFirst()).isPresent()) {
                return canidate.get();
            }
        }
        return clazz.getName();
    }

    public ObjectEvaluatableACE(Class<?> clazz, Right requestedRight, String storeToString) {
        this(ObjectEvaluatableACE.getElexisInterfaceName(clazz), requestedRight, storeToString);
    }

    public String getObject() {
        return this.object;
    }

    public boolean evaluate(IAccessControlService iac) {
        return iac.evaluate(this);
    }

    public byte[] getRequestedRightMap() {
        return this.requestedRightMap;
    }

    public short getRequested() {
        return this.requested;
    }

    public String getStoreToString() {
        return this.storeToString;
    }

    public String toString() {
        return String.valueOf(this.object) + "#" + Arrays.toString(this.requestedRightMap);
    }
}

