/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ac;

import ch.elexis.core.ac.Right;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.utils.OsgiServiceUtil;

public abstract class EvaluatableACE {
    private static IAccessControlService iacs;
    protected byte[] requestedRightMap = new byte[Right.values().length];
    protected short requested;

    private IAccessControlService getAccessControlService() {
        if (iacs == null) {
            iacs = OsgiServiceUtil.getService(IAccessControlService.class).get();
        }
        return iacs;
    }

    public boolean eval() {
        return this.getAccessControlService().evaluate(this);
    }

    public Boolean fastEval() {
        return false;
    }

    public EvaluatableACE and(Right requestedRight) {
        this.requestedRightMap[requestedRight.ordinal()] = 1;
        this.requested = (short)(this.requested | 1 << requestedRight.ordinal());
        return this;
    }
}

