/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ac;

import ch.elexis.core.ac.ACEAccessBitMap;
import ch.elexis.core.ac.AccessControlList;
import ch.elexis.core.ac.Right;
import java.util.Map;

public class AccessControlListUtil {
    public static AccessControlList merge(AccessControlList firstAcl, AccessControlList secondAcl) {
        AccessControlList clonedAcl = new AccessControlList(firstAcl);
        if (secondAcl.getRolesRepresented().size() != 1) {
            throw new IllegalArgumentException("Cannot merge a combined ACL");
        }
        if (clonedAcl.getRolesRepresented().contains(secondAcl.getRolesRepresented().iterator().next())) {
            return clonedAcl;
        }
        clonedAcl.getRolesRepresented().add(secondAcl.getRolesRepresented().iterator().next());
        AccessControlListUtil.mergeObjectACE(clonedAcl, secondAcl);
        return clonedAcl;
    }

    private static void mergeObjectACE(AccessControlList clonedAcl, AccessControlList secondAcl) {
        Map<String, ACEAccessBitMap> firstObjectAcl = clonedAcl.getObject();
        Map<String, ACEAccessBitMap> secondObjectAcl = secondAcl.getObject();
        if (secondObjectAcl != null) {
            secondObjectAcl.forEach((k, v) -> {
                if (firstObjectAcl.containsKey(k)) {
                    byte[] firstObject = ((ACEAccessBitMap)firstObjectAcl.get(k)).getAccessRightMap();
                    byte[] secondObject = ((ACEAccessBitMap)secondObjectAcl.get(k)).getAccessRightMap();
                    AccessControlListUtil.mergeRight(Right.CREATE, firstObject, secondObject);
                    AccessControlListUtil.mergeRight(Right.READ, firstObject, secondObject);
                    AccessControlListUtil.mergeRight(Right.UPDATE, firstObject, secondObject);
                    AccessControlListUtil.mergeRight(Right.DELETE, firstObject, secondObject);
                    AccessControlListUtil.mergeRight(Right.EXECUTE, firstObject, secondObject);
                    AccessControlListUtil.mergeRight(Right.VIEW, firstObject, secondObject);
                    AccessControlListUtil.mergeRight(Right.EXPORT, firstObject, secondObject);
                    AccessControlListUtil.mergeRight(Right.IMPORT, firstObject, secondObject);
                    AccessControlListUtil.mergeRight(Right.REMOVE, firstObject, secondObject);
                    firstObjectAcl.put((String)k, new ACEAccessBitMap(firstObject));
                } else {
                    firstObjectAcl.put((String)k, (ACEAccessBitMap)v);
                }
            });
        }
        Map<String, ACEAccessBitMap> firstSystemCommandAcl = clonedAcl.getSystemCommand();
        Map<String, ACEAccessBitMap> secondSystemCommandAcl = secondAcl.getSystemCommand();
        if (secondSystemCommandAcl != null) {
            secondSystemCommandAcl.forEach((k, v) -> {
                if (firstSystemCommandAcl.containsKey(k)) {
                    byte[] firstSystemCommand = ((ACEAccessBitMap)firstSystemCommandAcl.get(k)).getAccessRightMap();
                    byte[] secondSystemCommand = ((ACEAccessBitMap)secondSystemCommandAcl.get(k)).getAccessRightMap();
                    AccessControlListUtil.mergeRight(Right.CREATE, firstSystemCommand, secondSystemCommand);
                    AccessControlListUtil.mergeRight(Right.READ, firstSystemCommand, secondSystemCommand);
                    AccessControlListUtil.mergeRight(Right.UPDATE, firstSystemCommand, secondSystemCommand);
                    AccessControlListUtil.mergeRight(Right.DELETE, firstSystemCommand, secondSystemCommand);
                    AccessControlListUtil.mergeRight(Right.EXECUTE, firstSystemCommand, secondSystemCommand);
                    AccessControlListUtil.mergeRight(Right.VIEW, firstSystemCommand, secondSystemCommand);
                    AccessControlListUtil.mergeRight(Right.EXPORT, firstSystemCommand, secondSystemCommand);
                    AccessControlListUtil.mergeRight(Right.IMPORT, firstSystemCommand, secondSystemCommand);
                    AccessControlListUtil.mergeRight(Right.REMOVE, firstSystemCommand, secondSystemCommand);
                    firstSystemCommandAcl.put((String)k, new ACEAccessBitMap(firstSystemCommand));
                } else {
                    firstSystemCommandAcl.put((String)k, (ACEAccessBitMap)v);
                }
            });
        }
    }

    private static void mergeRight(Right right, byte[] firstObject, byte[] secondObject) {
        if (firstObject[right.ordinal()] != 4 && firstObject[right.ordinal()] < secondObject[right.ordinal()]) {
            firstObject[right.ordinal()] = secondObject[right.ordinal()];
        }
    }
}

