/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.webdav;

import ch.elexis.core.webdav.WebdavFileNameFilter;
import ch.elexis.core.webdav.WebdavPool;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.slf4j.LoggerFactory;

public class WebdavFile
extends URLConnection {
    private static QName COLLECTION_TYPE = new QName("DAV:", "collection");
    private static final Set<QName> PROPERTIES = Set.of(new QName("DAV:", "getetag", "d"), new QName("DAV:", "resourcetype", "d"), new QName("DAV:", "getlastmodified", "d"), new QName("DAV:", "getcontentlength", "d"), new QName("http://owncloud.org/ns", "permissions", "oc"));
    private Sardine webdav;
    private Object isWriting;

    public WebdavFile(URL url) throws MalformedURLException {
        super(url);
        if (url.getUserInfo() != null) {
            this.webdav = WebdavPool.INSTANCE.getSardine(url);
        }
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        PipedOutputStream out = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream(out);
        CompletableFuture.runAsync(() -> {
            block14: {
                try {
                    try {
                        this.isWriting = new Object();
                        this.webdav.put(this.url.toString(), (InputStream)in, null, false);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).warn("Error writing file [{}]", (Object)this.url.toString(), (Object)e);
                        Object object = this.isWriting;
                        synchronized (object) {
                            this.isWriting.notifyAll();
                            this.isWriting = null;
                            break block14;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = this.isWriting;
                    synchronized (object) {
                        this.isWriting.notifyAll();
                        this.isWriting = null;
                    }
                    throw throwable;
                }
                Object object = this.isWriting;
                synchronized (object) {
                    this.isWriting.notifyAll();
                    this.isWriting = null;
                }
            }
        });
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitWriteComplete() {
        if (this.isWriting != null) {
            Object object = this.isWriting;
            synchronized (object) {
                try {
                    this.isWriting.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.webdav.get(this.url.toString());
    }

    @Override
    public long getContentLengthLong() {
        try {
            DavResource davResource = this.getDavResource();
            if (davResource != null) {
                return davResource.getContentLength();
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Cannot determine length", (Throwable)e);
        }
        return -1L;
    }

    public boolean isDirectory() throws IOException {
        DavResource davResource = this.getDavResource();
        if (davResource != null) {
            List resourceTypes = davResource.getResourceTypes();
            return resourceTypes.contains(COLLECTION_TYPE);
        }
        return false;
    }

    private DavResource getDavResource() throws IOException {
        List propfind;
        block4: {
            try {
                propfind = this.webdav.propfind(this.url.toString(), 0, PROPERTIES);
                if (!propfind.isEmpty()) break block4;
                return null;
            }
            catch (SardineException se) {
                if (se.getStatusCode() == 404) {
                    return null;
                }
                throw se;
            }
        }
        return (DavResource)propfind.get(0);
    }

    public void delete() throws IOException {
        this.webdav.delete(this.getURL().toString());
    }

    public boolean exists() throws IOException {
        return this.webdav.exists(this.getURL().toString());
    }

    public void mkdir() throws IOException {
        this.webdav.createDirectory(this.url.toString());
    }

    public String getParent() throws URISyntaxException {
        URI uri = this.getURL().toURI();
        URI parent = uri.getPath().endsWith("/") ? uri.resolve("..") : uri.resolve(".");
        return parent.toString();
    }

    public boolean canRead() throws IOException {
        return this.getDavResource() != null;
    }

    public boolean canWrite() throws IOException {
        DavResource davResource = this.getDavResource();
        if (davResource != null) {
            String permissions = (String)davResource.getCustomProps().get("permissions");
            if (davResource.getResourceTypes().contains(COLLECTION_TYPE)) {
                return permissions.contains("C") && permissions.contains("K");
            }
            return permissions.contains("W");
        }
        return false;
    }

    public void move(URL destination) throws IOException {
        this.webdav.move(this.getURL().toString(), destination.toString());
    }

    public WebdavFile[] listFiles(WebdavFileNameFilter filenameFilter) throws IOException {
        List list = this.webdav.list(this.getURL().toString(), 1);
        list.remove(0);
        if (filenameFilter != null) {
            List<DavResource> collect = list.stream().filter(wdv -> filenameFilter.accept(wdv.getName())).collect(Collectors.toList());
            return this.toWebdavFileArray(collect);
        }
        return this.toWebdavFileArray(list);
    }

    private WebdavFile[] toWebdavFileArray(List<DavResource> collect) {
        WebdavFile[] result = new WebdavFile[collect.size()];
        int i = 0;
        for (DavResource davResource : collect) {
            URL url = null;
            try {
                URI href = davResource.getHref();
                url = href.isAbsolute() ? href.toURL() : this.getURL().toURI().resolve(href).toURL();
                result[i++] = new WebdavFile(url);
            }
            catch (MalformedURLException | URISyntaxException e) {
                LoggerFactory.getLogger(this.getClass()).error("malformed url [{}]", (Object)davResource, (Object)e);
            }
        }
        return result;
    }
}

