/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.textsystem;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.text.MimeTypeUtil;
import ch.elexis.data.Mandant;

public class TextTemplatePrintSettings {
    public static final String TXT_TEMPLATE_PREFIX_PUBLIC = "texttemplates/public/";
    public static final String TXT_TEMPLATE_PREFIX_PRIVATE = "texttemplates/private/";
    public static final String TXT_TEMPLATE_PRINTER_SUFFIX = "/printer";
    public static final String TXT_TEMPLATE_TRAY_SUFFIX = "/tray";
    private static final String SEPARATOR = "/";
    private String printer;
    private String tray;

    public TextTemplatePrintSettings(String template, String mimeType) {
        this(template, mimeType, null, null, ElexisEventDispatcher.getSelectedMandator());
    }

    public TextTemplatePrintSettings(String template, String mimeType, @Nullable String alternatePrintCfg, @Nullable String alternateTrayCfg) {
        this(template, mimeType, alternatePrintCfg, alternateTrayCfg, ElexisEventDispatcher.getSelectedMandator());
    }

    public TextTemplatePrintSettings(String template, String mimeType, @Nullable String alternatePrintCfg, @Nullable String alternateTrayCfg, Mandant mandant) {
        String type = MimeTypeUtil.getSimpleName((String)mimeType);
        if (mandant != null) {
            String templateBase = TXT_TEMPLATE_PREFIX_PRIVATE + mandant.getId() + SEPARATOR + type + SEPARATOR + template;
            this.printer = this.getTemplatePrinterFromConfig(templateBase);
            this.tray = this.getTemplateTrayFromConfig(templateBase);
        }
        if (this.printer == null) {
            this.printer = this.getTemplatePrinterFromConfig(TXT_TEMPLATE_PREFIX_PUBLIC + type + SEPARATOR + template);
            this.tray = this.getTemplateTrayFromConfig(TXT_TEMPLATE_PREFIX_PUBLIC + type + SEPARATOR + template);
            if (this.printer == null && alternatePrintCfg != null && alternateTrayCfg != null) {
                this.printer = CoreHub.localCfg.get(alternatePrintCfg, null);
                this.tray = CoreHub.localCfg.get(alternateTrayCfg, null);
            }
        }
    }

    public String getPrinter() {
        return this.printer;
    }

    public String getTray() {
        return this.tray;
    }

    private String getTemplatePrinterFromConfig(String templateBase) {
        return CoreHub.localCfg.get(String.valueOf(templateBase) + TXT_TEMPLATE_PRINTER_SUFFIX, null);
    }

    private String getTemplateTrayFromConfig(String templateBase) {
        return CoreHub.localCfg.get(String.valueOf(templateBase) + TXT_TEMPLATE_TRAY_SUFFIX, null);
    }
}

