/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung.invoice;

import ch.elexis.core.ac.ACEAccessBitMapConstraint;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.data.DBConnection;
import ch.elexis.data.PersistentObject;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class InvoiceListSqlQuery {
    public static final String VIEW_FLD_INVOICENO = "InvoiceNo";
    public static final String VIEW_FLD_INVOICETOTAL = "InvoiceTotal";
    public static final String VIEW_FLD_OPENAMOUNT = "openAmount";
    public static final String VIEW_FLD_INVOICESTATE = "InvoiceState";
    public static final String VIEW_FLD_INVOICEDATE = "RnDatum";
    public static final String VIEW_FLD_INVOICESTATEDATE = "StatusDatum";
    public static final String REPLACEMENT_INVOICE_INNER_CONDITION = "REPLACE_WITH_INVOICE_INNER_CONDITION";
    public static final String REPLACEMENT_OUTER_CONDITION = "REPLACE_WITH_OUTER_CONDITION";

    public static String getSqlCountStats(boolean withConditions) {
        return "SELECT COUNT(InvoiceId), COUNT(DISTINCT (patientid)), SUM(invoiceTotal), SUM(openAmount) FROM " + InvoiceListSqlQuery.getSqlInvoice(withConditions);
    }

    public static String getSqlInvoice(boolean withConditions) {
        String query = null;
        DBConnection dbConnection = PersistentObject.getDefaultConnection();
        query = dbConnection != null && "postgresql".equalsIgnoreCase(dbConnection.getDBFlavor()) ? "( SELECT rz.id AS InvoiceId, rz.RnNummer AS InvoiceNo, rz.rndatum, rz.rndatumvon, rz.rndatumbis, rz.statusdatum, rz.InvoiceState, rz.InvoiceTotal, rz.MandantId, f.patientid AS PatientId, k.bezeichnung1 AS PatName1, k.bezeichnung2 AS PatName2, k.geschlecht AS PatSex, k.geburtsdatum AS PatDob, f.id AS FallId, f.gesetz AS FallGesetz, CASE WHEN (f.garantID IS NULL) THEN f.patientid ELSE f.garantID END FallGarantId, f.KostentrID AS FallKostentrID, rz.paymentCount, rz.paidAmount, rz.openAmount FROM (SELECT r.id, r.rnnummer, r.rndatum, r.rndatumvon, r.rndatumbis, r.statusdatum, r.fallid, r.MandantId, CAST(r.rnstatus AS NUMERIC) AS InvoiceState, CAST(r.betrag AS NUMERIC) AS InvoiceTotal, COUNT(z.id) AS paymentCount, CASE WHEN COUNT(z.id) = '0' THEN 0 ELSE SUM(CAST(z.betrag AS NUMERIC)) END paidAmount, CASE WHEN COUNT(z.id) = '0' THEN CAST(r.betrag AS NUMERIC) ELSE (CAST(r.betrag AS NUMERIC) - SUM(CAST(z.betrag AS NUMERIC))) END openAmount FROM RECHNUNGEN r LEFT JOIN zahlungen z ON z.rechnungsID = r.id AND z.deleted = '0' WHERE r.deleted = '0' REPLACE_WITH_INVOICE_INNER_CONDITION" + InvoiceListSqlQuery.addAobo() + " GROUP BY r.id) rz LEFT JOIN faelle f ON rz.FallID = f.ID LEFT JOIN kontakt k ON f.PatientID = k.id)x " + REPLACEMENT_OUTER_CONDITION + " " : "( SELECT rz.id AS InvoiceId, rz.RnNummer AS InvoiceNo, rz.rndatum, rz.rndatumvon, rz.rndatumbis, rz.statusdatum, rz.InvoiceState, rz.InvoiceTotal, rz.MandantId, f.patientid AS PatientId, k.bezeichnung1 AS PatName1, k.bezeichnung2 AS PatName2, k.geschlecht AS PatSex, k.geburtsdatum AS PatDob, f.id AS FallId, f.gesetz AS FallGesetz, CASE WHEN (f.garantID IS NULL) THEN f.patientid ELSE f.garantID END FallGarantId, f.KostentrID AS FallKostentrID, rz.paymentCount, rz.paidAmount, rz.openAmount FROM (SELECT r.id, r.rnnummer, r.rndatum, r.rndatumvon, r.rndatumbis, r.statusdatum, r.fallid, r.MandantId, CAST(r.rnstatus AS SIGNED) AS InvoiceState, CAST(r.betrag AS SIGNED) AS InvoiceTotal, COUNT(z.id) AS paymentCount, CASE WHEN COUNT(z.id) = 0 THEN 0 ELSE SUM(CAST(z.betrag AS SIGNED)) END paidAmount, CASE WHEN COUNT(z.id) = 0 THEN CAST(r.betrag AS SIGNED) ELSE (CAST(r.betrag AS SIGNED) - SUM(CAST(z.betrag AS SIGNED))) END openAmount FROM RECHNUNGEN r LEFT JOIN zahlungen z ON z.rechnungsID = r.id AND z.deleted = 0 WHERE r.deleted = 0 REPLACE_WITH_INVOICE_INNER_CONDITION" + InvoiceListSqlQuery.addAobo() + " GROUP BY r.id) rz LEFT JOIN faelle f ON rz.FallID = f.ID LEFT JOIN kontakt k ON f.PatientID = k.id )x " + REPLACEMENT_OUTER_CONDITION + " ";
        if (!withConditions && query != null) {
            query = query.replaceAll(REPLACEMENT_INVOICE_INNER_CONDITION, "");
            query = query.replace(REPLACEMENT_OUTER_CONDITION, "");
        }
        return query;
    }

    private static String addAobo() {
        Optional aoboOrSelf = AccessControlServiceHolder.get().isAoboOrSelf(EvACE.of(IInvoice.class, (Right)Right.READ));
        if (aoboOrSelf.isPresent()) {
            if (aoboOrSelf.get() == ACEAccessBitMapConstraint.AOBO) {
                String list = ConfigServiceHolder.get().getActiveUserContact("rechnungsliste/mandantenfiltered", "");
                if (!list.isBlank()) {
                    return " AND (r.MandantID IN (" + Arrays.stream(list.split(",")).map(s -> "'" + s.trim() + "'").collect(Collectors.joining(",")) + ") OR r.MandantID is null)";
                }
                return " AND (r.MandantID IN (" + AccessControlServiceHolder.get().getAoboMandatorIdsForSqlIn().stream().map(s -> "'" + s + "'").collect(Collectors.joining(",")) + ") OR r.MandantID is null)";
            }
            if (aoboOrSelf.get() == ACEAccessBitMapConstraint.SELF) {
                return " AND (r.MandantID = '" + AccessControlServiceHolder.get().getSelfMandatorId() + "' OR r.MandantID is null)";
            }
        }
        return "";
    }

    public static String getSqlFetch() {
        return " SELECT     InvoiceId,InvoiceNo,    rndatumvon,    rndatumbis,InvoiceState,InvoiceTotal,    PatientId,    PatName1,    PatName2,    PatSex,    PatDob,    FallId,    FallGesetz,    FallGarantId,    FallKostentrID,    paymentCount,    paidAmount,openAmount,StatusDatum FROM " + InvoiceListSqlQuery.getSqlInvoice(true) + "REPLACE_WITH_ORDER " + "REPLACE_WITH_LIMIT";
    }

    public static void fetchNumberOfPatientsAndInvoices(AtomicInteger countPatients, AtomicInteger countInvoices) throws IOException {
        DBConnection dbConnection = PersistentObject.getDefaultConnection();
        PreparedStatement ps = dbConnection.getPreparedStatement(InvoiceListSqlQuery.getSqlCountStats(false));
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ResultSet res = ps.executeQuery();){
                    while (res.next()) {
                        countInvoices.set(res.getInt(1));
                        countPatients.set(res.getInt(2));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                ElexisStatus elexisStatus = new ElexisStatus(4, "ch.elexis.core.data", 0, "Count stats failed", (Exception)e);
                ElexisStatus.fire((ElexisStatus)elexisStatus);
                dbConnection.releasePreparedStatement(ps);
            }
        }
        finally {
            dbConnection.releasePreparedStatement(ps);
        }
    }
}

